/*
 * Decompiled with CFR 0.152.
 */
package net.rocketplatform.game.client.mod.ui.variable;

import java.util.Map;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.rocketplatform.game.client.mod.RocketClientMod;
import net.rocketplatform.game.client.mod.ui.variable.VariableStorage;

public class VariableProcessor {
    public static String process(String input, VariableStorage storage) {
        for (Map.Entry<String, Object> entry : storage.getContents().entrySet()) {
            if (entry.getValue() == null) {
                RocketClientMod.getLogger().debug("Variable {} was not specified. Not storing anything.", (Object)entry.getKey());
                continue;
            }
            input = input.replace("$" + entry.getKey(), entry.getValue().toString());
        }
        return input;
    }

    public static Component processComponent(Component input, VariableStorage storage) {
        MutableComponent result;
        if (input instanceof TextComponent) {
            TextComponent textComponent = (TextComponent)input;
            result = new TextComponent(VariableProcessor.process(textComponent.m_131292_(), storage)).m_6270_(input.m_7383_());
        } else if (input instanceof TranslatableComponent) {
            TranslatableComponent translatableComponent = (TranslatableComponent)input;
            Object[] args = new Object[translatableComponent.m_131329_().length];
            for (int i = 0; i < args.length; ++i) {
                Object oldArg = translatableComponent.m_131329_()[i];
                if (oldArg instanceof Component) {
                    Component component = (Component)oldArg;
                    args[i] = VariableProcessor.processComponent(component, storage);
                    continue;
                }
                if (oldArg instanceof String) {
                    String str = (String)oldArg;
                    args[i] = VariableProcessor.process(str, storage);
                    continue;
                }
                args[i] = oldArg;
            }
            result = new TranslatableComponent(translatableComponent.m_131328_(), args).m_6270_(input.m_7383_());
        } else {
            return input;
        }
        for (Component sibling : input.m_7360_()) {
            result.m_7220_(VariableProcessor.processComponent(sibling, storage));
        }
        return result;
    }
}

