/*
 * Decompiled with CFR 0.152.
 */
package net.rocketplatform.game.client.mod.ui.template.layout.type.list;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.architectury.platform.Platform;
import dev.ftb.mods.ftblibrary.ui.GuiHelper;
import dev.ftb.mods.ftblibrary.ui.IScreenWrapper;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.input.Key;
import dev.ftb.mods.ftblibrary.ui.input.KeyModifiers;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import dev.ftb.mods.ftblibrary.util.WrappedIngredient;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.world.item.ItemStack;
import net.rocketplatform.game.client.mod.RocketClientMod;
import net.rocketplatform.game.client.mod.ui.loader.ListEntryLoader;
import net.rocketplatform.game.client.mod.ui.template.layout.screen.TemplateScreen;
import net.rocketplatform.game.client.mod.ui.template.layout.type.AbstractListLayoutTemplate;
import net.rocketplatform.game.client.mod.ui.template.layout.type.list.IListScreen;
import net.rocketplatform.game.client.mod.ui.template.layout.type.list.ListLayoutList;
import net.rocketplatform.game.client.mod.ui.template.layout.type.list.ListScreen;

public class ListScreenWrapper
extends Screen
implements IScreenWrapper,
IListScreen {
    protected final ListScreen screen;
    protected ListLayoutList list;
    protected final Theme theme;
    protected boolean initedOnce;
    protected final List<AbstractListLayoutTemplate.ListEntry> entries;
    protected final List<ListEntryLoader.ListEntryTemplate> entryTemplates;
    protected final TooltipList tooltipList = new TooltipList();
    private Consumer<ListLayoutList> listConsumer;

    public ListScreenWrapper(ListScreen screen, Theme theme, List<AbstractListLayoutTemplate.ListEntry> entries, List<ListEntryLoader.ListEntryTemplate> entryTemplates) {
        super(screen.getTitle());
        this.screen = screen;
        this.theme = theme;
        this.entries = entries;
        this.entryTemplates = entryTemplates;
        screen.setWrapper(this);
    }

    public void m_7856_() {
        super.m_7856_();
        this.screen.initGui();
        if (this.initedOnce) {
            this.list.m_93437_(this.screen.getWidth(), this.screen.getHeight(), 44, this.screen.getHeight() - 64);
        } else {
            this.initedOnce = true;
            if (this.list == null) {
                this.list = new ListLayoutList(Minecraft.m_91087_(), this.screen.getWidth(), this.screen.getHeight(), this.theme);
                if (this.listConsumer != null) {
                    this.listConsumer.accept(this.list);
                }
            }
            for (AbstractListLayoutTemplate.ListEntry entry : this.entries) {
                this.list.addEntry(new ListLayoutList.ListEntry(this.getGui(), this.list, entry, null));
            }
            for (ListEntryLoader.ListEntryTemplate template : this.entryTemplates) {
                AbstractListLayoutTemplate.ListEntry entry = template.entry();
                ListLayoutList.ListEntry internalEntry = new ListLayoutList.ListEntry(this.getGui(), this.list, entry, template.storage());
                this.list.addEntry(internalEntry);
            }
        }
        this.m_7787_((GuiEventListener)this.list);
    }

    public void refreshEntries() {
        ArrayList<ListLayoutList.ListEntry> newEntries = new ArrayList<ListLayoutList.ListEntry>();
        for (AbstractListLayoutTemplate.ListEntry entry : this.entries) {
            newEntries.add(new ListLayoutList.ListEntry(this.getGui(), this.list, entry, null));
        }
        CompletableFuture<List<ListEntryLoader.ListEntryTemplate>> newTemplateEntries = this.screen.getTemplate().getEntryLoader().loadEntries(this.screen.getStorage());
        newTemplateEntries.whenComplete((entries, e) -> {
            if (e != null) {
                RocketClientMod.getLogger().error("Failed to load list entries", e);
                return;
            }
            for (ListEntryLoader.ListEntryTemplate template : entries) {
                AbstractListLayoutTemplate.ListEntry entry = template.entry();
                ListLayoutList.ListEntry internalEntry = new ListLayoutList.ListEntry(this.getGui(), this.list, entry, template.storage());
                newEntries.add(internalEntry);
            }
            if (newEntries.isEmpty() && this.screen.getTemplate().getEmptyEntry() != null) {
                newEntries.add(new ListLayoutList.EmptyHeader(this.screen.getTemplateScreen(), this.screen.getTemplate().getEmptyEntry(), this.list, null, null));
            }
            this.list.refreshEntries(newEntries);
        });
    }

    public boolean m_7043_() {
        return this.screen.doesGuiPauseGame();
    }

    public boolean m_6375_(double x, double y, int button) {
        this.screen.updateMouseOver((int)x, (int)y);
        if (button == MouseButton.BACK.id) {
            this.screen.onBack();
            return true;
        }
        return this.screen.mousePressed(MouseButton.get((int)button)) || super.m_6375_(x, y, button);
    }

    public boolean m_6348_(double x, double y, int button) {
        this.screen.updateMouseOver((int)x, (int)y);
        this.screen.mouseReleased(MouseButton.get((int)button));
        return super.m_6348_(x, y, button);
    }

    public boolean m_6050_(double x, double y, double scroll) {
        return this.screen.mouseScrolled(scroll) || super.m_6050_(x, y, scroll);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        Object object;
        Key key = new Key(keyCode, scanCode, modifiers);
        if (this.screen.keyPressed(key)) {
            return true;
        }
        if (key.backspace()) {
            this.screen.onBack();
            return true;
        }
        if (this.screen.onClosedByKey(key)) {
            this.screen.closeGui(true);
            return true;
        }
        if (Platform.isModLoaded((String)"jei") && (object = WrappedIngredient.unwrap((Object)this.screen.getIngredientUnderMouse())) != null) {
            this.handleIngredientKey(key, object);
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_7920_(int keyCode, int scanCode, int modifiers) {
        Key key = new Key(keyCode, scanCode, modifiers);
        this.screen.keyReleased(key);
        return super.m_7920_(keyCode, scanCode, modifiers);
    }

    public boolean m_5534_(char keyChar, int modifiers) {
        if (this.screen.charTyped(keyChar, new KeyModifiers(modifiers))) {
            return true;
        }
        return super.m_5534_(keyChar, (int)keyChar);
    }

    private void handleIngredientKey(Key key, Object object) {
    }

    public void m_6305_(PoseStack graphics, int mouseX, int mouseY, float partialTicks) {
        this.screen.updateGui(mouseX, mouseY, partialTicks);
        this.m_7333_(graphics);
        GuiHelper.setupDrawing();
        int x = this.screen.getX();
        int y = this.screen.getY();
        int w = this.screen.width;
        int h = this.screen.height;
        Theme theme = this.screen.getTheme();
        this.screen.draw(graphics, theme, x, y, w, h);
        this.screen.drawForeground(graphics, theme, x, y, w, h);
        for (ListLayoutList.ListEntry entry : this.list.m_6702_()) {
            for (Widget widget : entry.getWidgets()) {
                widget.updateMouseOver(mouseX, mouseY);
            }
        }
        this.screen.addMouseOverText(this.tooltipList);
        if (!this.tooltipList.shouldRender()) {
            Object ingredient;
            Object object = this.screen.getIngredientUnderMouse();
            if (object instanceof WrappedIngredient && ((WrappedIngredient)object).tooltip && (ingredient = WrappedIngredient.unwrap((Object)object)) instanceof ItemStack && !((ItemStack)ingredient).m_41619_()) {
                graphics.m_85836_();
                graphics.m_85837_(0.0, 0.0, (double)this.tooltipList.zOffsetItemTooltip);
                this.m_6057_(graphics, (ItemStack)ingredient, mouseX, mouseY);
                graphics.m_85849_();
            }
        } else {
            this.tooltipList.render(graphics, mouseX, Math.max(mouseY, 18), this.screen.getScreen().m_85445_(), this.screen.getScreen().m_85446_(), theme.getFont());
        }
        this.tooltipList.reset();
    }

    public void m_7333_(PoseStack matrixStack) {
        if (this.screen.drawDefaultBackground(matrixStack)) {
            super.m_7333_(matrixStack);
        }
    }

    public void m_96624_() {
        super.m_96624_();
        this.screen.tick();
    }

    public ListScreen getGui() {
        return this.screen;
    }

    public void m_7861_() {
        this.screen.onClosed();
        super.m_7861_();
    }

    @Override
    public ListLayoutList getList() {
        return this.list;
    }

    @Override
    public TemplateScreen getTemplateScreen() {
        return this.screen;
    }

    @Override
    public void onListCreate(Consumer<ListLayoutList> listConsumer) {
        this.listConsumer = listConsumer;
    }
}

