/*
 * Decompiled with CFR 0.152.
 */
package net.rocketplatform.game.client.mod.ui.template.layout;

import com.google.gson.GsonBuilder;
import java.util.ArrayList;
import java.util.List;
import net.rocketplatform.game.client.mod.ui.template.layout.LayoutTemplate;
import net.rocketplatform.game.client.mod.ui.template.layout.LayoutType;
import net.rocketplatform.game.client.mod.ui.template.layout.type.ListLayoutTemplate;
import net.rocketplatform.game.client.mod.ui.template.layout.type.LoadingLayoutTemplate;
import net.rocketplatform.game.client.mod.ui.template.layout.type.PendingLayoutTemplate;
import net.rocketplatform.game.client.mod.ui.template.layout.type.SimpleLayoutTemplate;
import net.rocketplatform.game.client.mod.util.gson.PolymorphicTypeReader;

public final class LayoutTypes {
    private static final List<LayoutType<? extends LayoutTemplate>> VALUES = new ArrayList<LayoutType<? extends LayoutTemplate>>();
    public static final LayoutType<SimpleLayoutTemplate> SIMPLE = LayoutTypes.register("simple", SimpleLayoutTemplate.class, SimpleLayoutTemplate::new);
    public static final LayoutType<LoadingLayoutTemplate> LOADING = LayoutTypes.register("loading", LoadingLayoutTemplate.class, LoadingLayoutTemplate::new);
    public static final LayoutType<PendingLayoutTemplate> PENDING = LayoutTypes.register("pending", PendingLayoutTemplate.class, PendingLayoutTemplate::new);
    public static final LayoutType<ListLayoutTemplate> LIST = LayoutTypes.register("list", ListLayoutTemplate.class, ListLayoutTemplate::new);
    private static final PolymorphicTypeReader<LayoutTemplate> READER = new PolymorphicTypeReader<LayoutTemplate>(LayoutTemplate.class, LayoutType.class);

    public static <T extends LayoutTemplate> LayoutType<T> register(String type, Class<T> clazz, LayoutType.Factory<T> factory) {
        LayoutType<T> layoutType = new LayoutType<T>(type, clazz, factory);
        VALUES.add(layoutType);
        return layoutType;
    }

    public static void registerTypeAdapter(GsonBuilder builder) {
        READER.applyTo(builder);
    }
}

