/*
 * Decompiled with CFR 0.152.
 */
package net.rocketplatform.game.client.mod.ui.template.callback.type;

import com.google.gson.annotations.SerializedName;
import java.util.List;
import net.rocketplatform.game.client.mod.ui.template.callback.CallbackHolder;
import net.rocketplatform.game.client.mod.ui.template.callback.ElementCallback;
import net.rocketplatform.game.client.mod.ui.template.layout.screen.TemplateScreen;
import net.rocketplatform.game.client.mod.ui.variable.VariableProcessor;
import net.rocketplatform.game.client.mod.ui.variable.VariableStorage;
import org.jetbrains.annotations.Nullable;

public class StoreVariablesCallback
extends ElementCallback {
    private List<Variable> variables;
    @SerializedName(value="on_complete")
    private ElementCallback onComplete;

    public StoreVariablesCallback(String action) {
        super(action);
    }

    @Override
    public void onPress(TemplateScreen screen, @Nullable CallbackHolder holder, VariableStorage variableStorage) {
        for (Variable variable : this.variables) {
            String value = VariableProcessor.process(variable.value, variableStorage);
            if (variable.type != null) {
                value = switch (variable.type) {
                    case "int" -> Integer.parseInt(value);
                    case "float" -> Float.valueOf(Float.parseFloat(value));
                    case "double" -> Double.parseDouble(value);
                    case "long" -> Long.parseLong(value);
                    case "boolean" -> Boolean.parseBoolean(value);
                    default -> value;
                };
            }
            screen.getStorage().store(variable.key, value);
        }
        if (this.onComplete != null) {
            CallbackHolder.runCallbacks(screen, holder, this.onComplete, variableStorage);
        }
    }

    public static class Variable {
        private String key;
        private String value;
        private String type;

        public Variable(String key, String value, String type) {
            this.key = key;
            this.value = value;
            this.type = type;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        public String getType() {
            return this.type;
        }
    }
}

