/*
 * Decompiled with CFR 0.152.
 */
package net.rocketplatform.game.client.mod.ui.template.callback.type;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.annotations.SerializedName;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.rocketplatform.client.api.request.RocketRequest;
import net.rocketplatform.game.client.mod.RocketClientMod;
import net.rocketplatform.game.client.mod.ui.MultilineErrorScreen;
import net.rocketplatform.game.client.mod.ui.template.callback.CallbackHolder;
import net.rocketplatform.game.client.mod.ui.template.callback.ElementCallback;
import net.rocketplatform.game.client.mod.ui.template.callback.type.variable.VariableLoader;
import net.rocketplatform.game.client.mod.ui.template.layout.LayoutTemplate;
import net.rocketplatform.game.client.mod.ui.template.layout.screen.TemplateScreen;
import net.rocketplatform.game.client.mod.ui.variable.VariableStorage;
import net.rocketplatform.game.client.mod.util.GuiUtils;
import net.rocketplatform.game.client.mod.util.JsonUtil;
import org.jetbrains.annotations.Nullable;

public class RequestCallback
extends ElementCallback {
    private String request;
    private Map<String, Object> variables;
    @SerializedName(value="display_errors")
    private boolean displayErrors;
    @SerializedName(value="rate_limit")
    private Integer rateLimit;
    @SerializedName(value="loading_screen")
    private LayoutTemplate loadingScreen;
    @SerializedName(value="store_variables")
    private Map<String, String> storeVariables;
    @SerializedName(value="on_complete")
    private ElementCallback onComplete;
    @SerializedName(value="required_variable")
    private String requiredVariable;
    private long lastClickTime;

    public RequestCallback(String action) {
        super(action);
    }

    @Override
    public void onPress(TemplateScreen screen, @Nullable CallbackHolder holder, VariableStorage variableStorage) {
        Screen currentScreen;
        if (this.rateLimit != null) {
            long currentTime = System.currentTimeMillis();
            if (currentTime - this.lastClickTime < (long)this.rateLimit.intValue() * 1000L) {
                return;
            }
            this.lastClickTime = currentTime;
        }
        if (!GuiUtils.shouldProcess(this.requiredVariable, variableStorage)) {
            if (this.onComplete != null) {
                RenderSystem.m_69879_(() -> CallbackHolder.runCallbacks(screen, holder, this.onComplete, variableStorage));
            }
            return;
        }
        RocketRequest request = ((RocketRequest.RawBuilder)RocketRequest.builder().commandFromFile(RequestCallback.class, "requests/" + this.request + ".graphql")).build();
        HashMap<String, Object> variables = new HashMap<String, Object>();
        if (this.variables != null) {
            for (Map.Entry<String, Object> entry : this.variables.entrySet()) {
                if (entry.getValue().toString().startsWith("$")) {
                    variables.put(entry.getKey(), variableStorage.retrieve(entry.getValue().toString().substring(1)));
                    continue;
                }
                variables.put(entry.getKey(), entry.getValue());
            }
        }
        Screen screen2 = currentScreen = this.loadingScreen == null ? null : screen.getMinecraft().f_91080_;
        if (this.loadingScreen != null) {
            Screen loadingScreen = this.loadingScreen.createScreen(variableStorage);
            screen.getMinecraft().m_91152_(loadingScreen);
        }
        ((CompletableFuture)((CompletableFuture)RocketClientMod.getInstance().getClientHandler().thenCompose(client -> client.executeRequest(request, (Map<String, Object>)variables))).whenComplete((response, e) -> {
            JsonObject obj;
            JsonElement element;
            if (this.storeVariables != null) {
                JsonObject object = JsonParser.parseString((String)response.getJson(request.getRootField())).getAsJsonObject();
                for (Map.Entry<String, String> entry : this.storeVariables.entrySet()) {
                    String jsonName = entry.getKey();
                    String varName = entry.getValue();
                    if (jsonName.startsWith("loader:")) {
                        String loaderName = jsonName.substring(7);
                        VariableLoader<?> loader = VariableLoader.LOADERS.get(loaderName);
                        if (loader == null) {
                            RocketClientMod.getLogger().warn("Could not find loader for {}", (Object)loaderName);
                            continue;
                        }
                        Object value = loader.load(object);
                        if (value == null) {
                            RocketClientMod.getLogger().warn("Could not load variable {} from response", (Object)jsonName);
                            continue;
                        }
                        variableStorage.store(varName, value);
                        continue;
                    }
                    JsonElement val = JsonUtil.getNestedElement(object, jsonName);
                    if (val == null) {
                        RocketClientMod.getLogger().warn("Could not find variable {} in response", (Object)jsonName);
                        continue;
                    }
                    variableStorage.store(varName, val.getAsString());
                }
            }
            if (this.displayErrors && (element = JsonParser.parseString((String)response.getJson(request.getRootField()))) instanceof JsonObject && (obj = (JsonObject)element).has("error") && !obj.get("error").isJsonNull()) {
                JsonPrimitive error = obj.getAsJsonPrimitive("error");
                if (error != null && error.isString()) {
                    String errorMessage = error.getAsString().toLowerCase(Locale.ROOT);
                    TranslatableComponent component = new TranslatableComponent("rgp_client.requests.error." + errorMessage);
                    MultilineErrorScreen errorScreen = new MultilineErrorScreen((Component)new TranslatableComponent("rgp_client.gui.button.ftb_worlds"), (Component)component);
                    RenderSystem.m_69879_(() -> screen.getMinecraft().m_91152_((Screen)errorScreen));
                    return;
                }
                if (error != null) {
                    MultilineErrorScreen errorScreen = new MultilineErrorScreen((Component)new TranslatableComponent("rgp_client.gui.button.ftb_worlds"), (Component)new TranslatableComponent("rgp_client.requests.error.other"));
                    RenderSystem.m_69879_(() -> screen.getMinecraft().m_91152_((Screen)errorScreen));
                    return;
                }
            }
            if (currentScreen != null) {
                RenderSystem.m_69879_(() -> screen.getMinecraft().m_91152_(currentScreen));
            }
            if (e != null) {
                this.onError(holder, (Throwable)e);
                return;
            }
            if (this.onComplete != null) {
                RenderSystem.m_69879_(() -> CallbackHolder.runCallbacks(screen, holder, this.onComplete, variableStorage));
            }
        })).whenComplete((ignored, e) -> {
            if (e != null) {
                RocketClientMod.getLogger().error("An error occurred handling callback request.", e);
            }
        });
    }
}

