/*
 * Decompiled with CFR 0.152.
 */
package net.rocketplatform.game.client.mod.ui.loader;

import java.nio.file.Path;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.ErrorScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.level.storage.LevelStorageException;
import net.minecraft.world.level.storage.LevelSummary;
import net.rocketplatform.game.client.mod.RocketClientMod;
import net.rocketplatform.game.client.mod.ui.loader.ListEntryLoader;
import net.rocketplatform.game.client.mod.ui.template.element.ElementTemplate;
import net.rocketplatform.game.client.mod.ui.template.layout.type.AbstractListLayoutTemplate;
import net.rocketplatform.game.client.mod.ui.variable.VariableProcessor;
import net.rocketplatform.game.client.mod.ui.variable.VariableStorage;
import org.jetbrains.annotations.Nullable;

public class SingleplayerWorldEntryLoader
extends ListEntryLoader {
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat();

    public SingleplayerWorldEntryLoader(String type, AbstractListLayoutTemplate.ListEntry entryTemplate) {
        super(type, entryTemplate);
    }

    @Override
    public CompletableFuture<List<ListEntryLoader.ListEntryTemplate>> loadEntries(@Nullable VariableStorage storage) {
        AbstractListLayoutTemplate.ListEntry entryTemplate = this.getEntryTemplate();
        if (storage == null) {
            RocketClientMod.getLogger().warn("No storage provided for singleplayer world list entry loader, so no entries will be loaded.");
            return CompletableFuture.completedFuture(List.of());
        }
        List<LevelSummary> levels = SingleplayerWorldEntryLoader.loadLevels();
        if (levels.isEmpty()) {
            return CompletableFuture.completedFuture(List.of());
        }
        ArrayList<ListEntryLoader.ListEntryTemplate> entries = new ArrayList<ListEntryLoader.ListEntryTemplate>();
        for (LevelSummary level : levels) {
            Path levelPath = Minecraft.m_91087_().m_91392_().m_78257_().resolve(level.m_78358_());
            VariableStorage worldStorage = new VariableStorage();
            worldStorage.store("worldPath", levelPath.toString());
            worldStorage.store("worldId", level.m_78358_());
            worldStorage.store("worldName", level.m_78361_());
            worldStorage.store("worldInfo", level.m_78376_().getString());
            worldStorage.store("worldIcon", level.m_78362_().toPath().toUri());
            worldStorage.store("worldLastPlayed", DATE_FORMAT.format(new Date(level.m_78366_())));
            worldStorage.store("worldGameMode", level.m_78367_().m_46405_());
            List<ElementTemplate<?>> elements = SingleplayerWorldEntryLoader.processElements(entryTemplate, worldStorage);
            AbstractListLayoutTemplate.ListEntry entry = new AbstractListLayoutTemplate.ListEntry(VariableProcessor.process(entryTemplate.getId(), worldStorage), elements, entryTemplate.requiredDoubleClickVariable(), entryTemplate.getCallback(), entryTemplate.selectedCallback());
            entries.add(new ListEntryLoader.ListEntryTemplate(entry, worldStorage));
        }
        return CompletableFuture.completedFuture(entries);
    }

    private static List<LevelSummary> loadLevels() {
        try {
            return Minecraft.m_91087_().m_91392_().m_78244_();
        }
        catch (LevelStorageException e) {
            SingleplayerWorldEntryLoader.handleLevelLoadFailure((Component)new TextComponent(e.getLocalizedMessage()));
            return List.of();
        }
    }

    private static void handleLevelLoadFailure(Component exceptionMessage) {
        Minecraft.m_91087_().m_91152_((Screen)new ErrorScreen((Component)new TranslatableComponent("selectWorld.unable_to_load"), exceptionMessage));
    }
}

