/*
 * Decompiled with CFR 0.152.
 */
package net.rocketplatform.game.client.mod.ui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.ui.GuiHelper;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.components.toasts.ToastComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.Nullable;

public class MultilineToast
implements Toast {
    private static final int MAX_LINE_SIZE = 200;
    private static final int LINE_SPACING = 12;
    private static final int MARGIN = 10;
    private static final int TOAST_WIDTH = 160;
    private static final int TOAST_HEIGHT = 32;
    private final long displayTime;
    private final Icon icon;
    private final Component title;
    private final List<FormattedCharSequence> messageLines;
    private long lastChanged;
    private boolean changed;
    private final int width;

    private MultilineToast(Icon icon, long displayTime, Component title, @Nullable Component message) {
        this(icon, displayTime, title, MultilineToast.nullToEmpty(message), Math.max(160, 30 + Math.max(Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)title), message == null ? 0 : Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)message))));
    }

    public static MultilineToast create(Minecraft minecraft, Icon icon, long displayTime, Component title, Component message) {
        List list = minecraft.f_91062_.m_92923_((FormattedText)message, 200);
        int lineWidth = Math.max(200, list.stream().mapToInt(arg_0 -> ((Font)minecraft.f_91062_).m_92724_(arg_0)).max().orElse(200));
        return new MultilineToast(icon, displayTime, title, list, lineWidth + 30);
    }

    private MultilineToast(Icon icon, long displayTime, Component title, List<FormattedCharSequence> messageLines, int width) {
        this.icon = icon;
        this.displayTime = displayTime;
        this.title = title;
        this.messageLines = messageLines;
        this.width = width;
    }

    private static List<FormattedCharSequence> nullToEmpty(@Nullable Component message) {
        return message == null ? List.of() : List.of(message.m_7532_());
    }

    public int m_7828_() {
        return this.width;
    }

    public int m_94899_() {
        return 20 + Math.max(this.messageLines.size(), 1) * 12;
    }

    public Toast.Visibility m_7172_(PoseStack guiGraphics, ToastComponent toastComponent, long timeSinceLastVisible) {
        int height;
        if (this.changed) {
            this.lastChanged = timeSinceLastVisible;
            this.changed = false;
        }
        GuiHelper.setupDrawing();
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)f_94893_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int width = this.m_7828_();
        if (width == 160 && this.messageLines.size() <= 1) {
            toastComponent.m_93228_(guiGraphics, 30, 0, 0, 0, width, this.m_94899_());
        } else {
            height = this.m_94899_();
            int lineHeight = Math.min(4, height - 28);
            this.renderBackgroundRow(guiGraphics, toastComponent, width, 0, 0, 28);
            for (int i = 28; i < height - lineHeight; i += 10) {
                this.renderBackgroundRow(guiGraphics, toastComponent, width, 16, i, Math.min(16, height - i - lineHeight));
            }
            this.renderBackgroundRow(guiGraphics, toastComponent, width, 32 - lineHeight, height - lineHeight, lineHeight);
        }
        if (this.messageLines == null) {
            toastComponent.m_94929_().f_91062_.m_92889_(guiGraphics, this.title, 30.0f, 12.0f, -256);
        } else {
            toastComponent.m_94929_().f_91062_.m_92889_(guiGraphics, this.title, 30.0f, 7.0f, -256);
            for (height = 0; height < this.messageLines.size(); ++height) {
                toastComponent.m_94929_().f_91062_.m_92877_(guiGraphics, this.messageLines.get(height), 30.0f, (float)(18 + height * 12), -1);
            }
        }
        if (this.icon != null) {
            this.icon.draw(guiGraphics, 8, 8, 16, 16);
        }
        return timeSinceLastVisible >= this.displayTime ? Toast.Visibility.HIDE : Toast.Visibility.SHOW;
    }

    private void renderBackgroundRow(PoseStack guiGraphics, ToastComponent toastComponent, int width, int rowType, int yPos, int rowHeight) {
        int leftPadding = rowType == 0 ? 20 : 5;
        int rightPadding = Math.min(60, width - leftPadding);
        toastComponent.m_93228_(guiGraphics, 0, yPos, 0, rowType, leftPadding, rowHeight);
        for (int xPos = leftPadding; xPos < width - rightPadding; xPos += 64) {
            toastComponent.m_93228_(guiGraphics, xPos, yPos, 32, rowType, Math.min(64, width - xPos - rightPadding), rowHeight);
        }
        toastComponent.m_93228_(guiGraphics, width - rightPadding, yPos, 160 - rightPadding, rowType, rightPadding, rowHeight);
    }
}

