/*
 * Decompiled with CFR 0.152.
 */
package dev.rdh.createunlimited.lib.difflib.patch;

import dev.rdh.createunlimited.lib.difflib.patch.PatchFailedException;
import dev.rdh.createunlimited.lib.difflib.patch.VerifyChunk;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public final class Chunk<T>
implements Serializable {
    private final int position;
    private List<T> lines;
    private final List<Integer> changePosition;

    public Chunk(int position, List<T> lines, List<Integer> changePosition) {
        this.position = position;
        this.lines = new ArrayList<T>(lines);
        this.changePosition = changePosition != null ? new ArrayList<Integer>(changePosition) : null;
    }

    public Chunk(int position, List<T> lines) {
        this(position, lines, null);
    }

    public Chunk(int position, T[] lines, List<Integer> changePosition) {
        this.position = position;
        this.lines = Arrays.asList(lines);
        this.changePosition = changePosition != null ? new ArrayList<Integer>(changePosition) : null;
    }

    public Chunk(int position, T[] lines) {
        this(position, lines, null);
    }

    public VerifyChunk verifyChunk(List<T> target) throws PatchFailedException {
        return this.verifyChunk(target, 0, this.getPosition());
    }

    public VerifyChunk verifyChunk(List<T> target, int fuzz, int position) throws PatchFailedException {
        int startIndex = fuzz;
        int lastIndex = this.size() - fuzz;
        int last = position + this.size() - 1;
        if (position + fuzz > target.size() || last - fuzz > target.size()) {
            return VerifyChunk.POSITION_OUT_OF_TARGET;
        }
        for (int i = startIndex; i < lastIndex; ++i) {
            if (target.get(position + i).equals(this.lines.get(i))) continue;
            return VerifyChunk.CONTENT_DOES_NOT_MATCH_TARGET;
        }
        return VerifyChunk.OK;
    }

    public int getPosition() {
        return this.position;
    }

    public void setLines(List<T> lines) {
        this.lines = lines;
    }

    public List<T> getLines() {
        return this.lines;
    }

    public List<Integer> getChangePosition() {
        return this.changePosition;
    }

    public int size() {
        return this.lines.size();
    }

    public int last() {
        return this.getPosition() + this.size() - 1;
    }

    public int hashCode() {
        return Objects.hash(this.lines, this.position, this.size());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Chunk other = (Chunk)obj;
        if (this.lines == null ? other.lines != null : !this.lines.equals(other.lines)) {
            return false;
        }
        return this.position == other.position;
    }

    public String toString() {
        return "[position: " + this.position + ", size: " + this.size() + ", lines: " + this.lines + "]";
    }
}

