/*
 * Decompiled with CFR 0.152.
 */
package dev.rdh.createunlimited.lib.classdiff.util;

import dev.rdh.createunlimited.lib.classdiff.util.SyntheticLabelNode;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.stream.StreamSupport;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.LabelNode;

public class LabelMap
implements Iterable<LabelNode> {
    public static final LabelMap EMPTY = new LabelMap(new LabelNode[0]);
    private final LabelNode[] byId;
    private final Map<LabelNode, Integer> toId;

    public LabelMap(LabelNode ... labels) {
        this.byId = labels;
        this.toId = new HashMap<LabelNode, Integer>(labels.length);
        for (LabelNode label : labels) {
            this.toId.put(label, this.toId.size());
        }
    }

    public LabelMap(Iterable<AbstractInsnNode> insns) {
        this((LabelNode[])StreamSupport.stream(insns.spliterator(), false).filter(i -> i instanceof LabelNode).map(i -> (LabelNode)i).toArray(LabelNode[]::new));
    }

    public int size() {
        return this.byId.length;
    }

    public LabelNode byId(int id) {
        return this.byId[id];
    }

    public int getId(LabelNode label) {
        if (label instanceof SyntheticLabelNode) {
            return ((SyntheticLabelNode)label).getId();
        }
        return this.toId.get(label);
    }

    public LabelNode resolve(LabelNode label) {
        if (label instanceof SyntheticLabelNode) {
            return this.byId[((SyntheticLabelNode)label).getId()];
        }
        return label;
    }

    @Override
    public Iterator<LabelNode> iterator() {
        return new Iterator<LabelNode>(){
            int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < LabelMap.this.size();
            }

            @Override
            public LabelNode next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return LabelMap.this.byId(this.index++);
            }
        };
    }
}

