/*
 * Decompiled with CFR 0.152.
 */
package dev.rdh.createunlimited.lib.classdiff.format;

import dev.rdh.createunlimited.lib.classdiff.format.Context;
import dev.rdh.createunlimited.lib.classdiff.format.DiffVisitor;
import dev.rdh.createunlimited.lib.classdiff.format.FieldDiffVisitor;
import dev.rdh.createunlimited.lib.classdiff.format.MethodDiffVisitor;
import dev.rdh.createunlimited.lib.classdiff.format.ModuleDiffVisitor;
import dev.rdh.createunlimited.lib.classdiff.format.RecordComponentDiffVisitor;
import dev.rdh.createunlimited.lib.classdiff.util.ByteReader;
import dev.rdh.createunlimited.lib.classdiff.util.InsnListAdapter;
import dev.rdh.createunlimited.lib.classdiff.util.LabelMap;
import dev.rdh.createunlimited.lib.classdiff.util.MemberName;
import dev.rdh.createunlimited.lib.classdiff.util.PatchReader;
import dev.rdh.createunlimited.lib.classdiff.util.ReflectUtils;
import dev.rdh.createunlimited.lib.classdiff.util.SyntheticLabelNode;
import dev.rdh.createunlimited.lib.classdiff.util.Util;
import dev.rdh.createunlimited.lib.difflib.patch.DeltaType;
import dev.rdh.createunlimited.lib.difflib.patch.Patch;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ConstantDynamic;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.FrameNode;
import org.objectweb.asm.tree.IincInsnNode;
import org.objectweb.asm.tree.InnerClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.InvokeDynamicInsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.LocalVariableAnnotationNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.LookupSwitchInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.ModuleExportNode;
import org.objectweb.asm.tree.ModuleNode;
import org.objectweb.asm.tree.ModuleOpenNode;
import org.objectweb.asm.tree.ModuleProvideNode;
import org.objectweb.asm.tree.ModuleRequireNode;
import org.objectweb.asm.tree.MultiANewArrayInsnNode;
import org.objectweb.asm.tree.ParameterNode;
import org.objectweb.asm.tree.RecordComponentNode;
import org.objectweb.asm.tree.TableSwitchInsnNode;
import org.objectweb.asm.tree.TryCatchBlockNode;
import org.objectweb.asm.tree.TypeAnnotationNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class DiffReader {
    private int[] constantOffsets;
    private final PatchReader<String> classPatchReader = new PatchReader<String>(reader -> {
        reader.skip(2);
        return this.readClass(reader.pointer() - 2);
    });
    private final PatchReader<AnnotationNode> annotationPatchReader = new PatchReader<AnnotationNode>(reader -> {
        AnnotationNode result = new AnnotationNode(this.readUtf8(reader.pointer()));
        reader.pointer(this.readElementValues((AnnotationVisitor)result, reader.pointer() + 2, true));
        return result;
    });
    private final PatchReader<TypeAnnotationNode> typeAnnotationPatchReader = new PatchReader<TypeAnnotationNode>(this::readTypeAnnotation);
    private final PatchReader<MemberName> memberNamePatchReader = new PatchReader<MemberName>(reader -> {
        int nameAndTypeOffset = this.constantOffsets[reader.readShort()];
        return new MemberName(this.readUtf8(nameAndTypeOffset), this.readUtf8(nameAndTypeOffset + 2));
    });
    private final PatchReader<String> packagePatchReader = new PatchReader<String>(reader -> {
        reader.skip(2);
        return this.readPackage(reader.pointer() - 2);
    });
    private final byte[] contents;
    private int version;
    private String[] constantStringCache;
    private char[] charBuffer;
    private int startPos;
    private ConstantDynamic[] condyCache;
    private int[] bsmOffsets;
    private final ThreadLocal<Context> context = new ThreadLocal();

    public DiffReader(byte[] contents) {
        this.contents = contents;
        this.readStart();
    }

    private void readStart() {
        if (this.readInt(0) != -341053524) {
            throw new IllegalArgumentException("Class diff did not start with magic 0xEBABEFAC");
        }
        this.version = this.readShort(4);
        if (this.version < 1 || this.version > 1) {
            throw new IllegalArgumentException("Unsupported class diff version. Read " + this.version + ". Class diff only supports 1 through " + 1 + ".");
        }
        int constantCount = this.readShort(6);
        this.constantOffsets = new int[constantCount + 1];
        this.constantStringCache = new String[constantCount + 1];
        int maxStringSize = 0;
        int pointer = 8;
        boolean hasCondy = false;
        boolean hasBsm = false;
        for (int i = 1; i < constantCount; ++i) {
            int size;
            this.constantOffsets[i] = pointer + 1;
            switch (this.contents[pointer]) {
                case 3: 
                case 4: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    size = 5;
                    break;
                }
                case 17: {
                    size = 5;
                    hasBsm = true;
                    hasCondy = true;
                    break;
                }
                case 18: {
                    size = 5;
                    hasBsm = true;
                    break;
                }
                case 5: 
                case 6: {
                    size = 9;
                    ++i;
                    break;
                }
                case 1: {
                    size = 3 + this.readShort(pointer + 1);
                    if (size <= maxStringSize) break;
                    maxStringSize = size;
                    break;
                }
                case 15: {
                    size = 4;
                    break;
                }
                case 7: 
                case 8: 
                case 16: 
                case 19: 
                case 20: {
                    size = 3;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown constant type: " + this.contents[pointer]);
                }
            }
            pointer += size;
        }
        this.charBuffer = new char[maxStringSize];
        this.startPos = pointer;
        if (hasCondy) {
            this.condyCache = new ConstantDynamic[constantCount];
        }
        if (hasBsm) {
            this.bsmOffsets = this.readBsmAttribute();
        }
    }

    public void accept(DiffVisitor visitor, ClassNode node) {
        int i;
        Patch<String> interfacePatch;
        this.context.set(new Context());
        ByteReader reader = new ByteReader(this.contents, this.startPos + 14);
        if (reader.readShort() == 0) {
            interfacePatch = null;
        } else {
            reader.skip(-2);
            interfacePatch = this.classPatchReader.readPatch(reader, Util.nullToEmpty(node.interfaces));
        }
        visitor.visit(this.version, this.readInt(this.startPos), this.readInt(this.startPos + 4), this.readClass(this.startPos + 8), this.readUtf8(this.startPos + 10), this.readClass(this.startPos + 12), interfacePatch);
        int attributeCount = reader.readShort();
        for (i = 0; i < attributeCount; ++i) {
            String attributeName = this.readUtf8(reader.pointer());
            if (attributeName == null) {
                throw new IllegalArgumentException("null attribute name at address " + Integer.toHexString(reader.pointer()));
            }
            reader.skip(2);
            int attributeLength = reader.readInt();
            int endPos = reader.pointer() + attributeLength;
            switch (attributeName) {
                case "Source": {
                    visitor.visitSource(this.readUtf8(reader.pointer()), this.readUtf8(reader.pointer() + 2));
                    break;
                }
                case "InnerClasses": {
                    visitor.visitInnerClasses(new PatchReader<InnerClassNode>(reader1 -> {
                        reader1.skip(6);
                        return new InnerClassNode(this.readClass(reader1.pointer() - 6), this.readClass(reader1.pointer() - 4), this.readUtf8(reader1.pointer() - 2), reader1.readShort());
                    }).readPatch(reader, Util.nullToEmpty(node.innerClasses)));
                    break;
                }
                case "OuterClasses": {
                    visitor.visitOuterClass(this.readClass(reader.pointer()), this.readClass(reader.pointer() + 2), this.readClass(reader.pointer() + 4));
                    break;
                }
                case "NestHost": {
                    visitor.visitNestHost(this.readClass(reader.pointer()));
                    break;
                }
                case "NestMembers": {
                    visitor.visitNestMembers(this.classPatchReader.readPatch(reader, Util.nullToEmpty(node.nestMembers)));
                    break;
                }
                case "PermittedSubclasses": {
                    visitor.visitPermittedSubclasses(this.classPatchReader.readPatch(reader, Util.nullToEmpty(node.permittedSubclasses)));
                    break;
                }
                case "VisibleAnnotations": {
                    visitor.visitAnnotations(this.annotationPatchReader.readPatch(reader, Util.nullToEmpty(node.visibleAnnotations)), true);
                    break;
                }
                case "InvisibleAnnotations": {
                    visitor.visitAnnotations(this.annotationPatchReader.readPatch(reader, Util.nullToEmpty(node.invisibleAnnotations)), false);
                    break;
                }
                case "VisibleTypeAnnotations": {
                    visitor.visitTypeAnnotations(this.typeAnnotationPatchReader.readPatch(reader, Util.nullToEmpty(node.visibleTypeAnnotations)), true);
                    break;
                }
                case "InvisibleTypeAnnotations": {
                    visitor.visitTypeAnnotations(this.typeAnnotationPatchReader.readPatch(reader, Util.nullToEmpty(node.invisibleTypeAnnotations)), false);
                    break;
                }
                case "RecordComponents": {
                    visitor.visitRecordComponents(this.memberNamePatchReader.readPatch(reader, node.recordComponents != null ? MemberName.fromRecordComponents(node.recordComponents) : Collections.emptyList()));
                    int l = reader.readShort();
                    for (int j = 0; j < l; ++j) {
                        this.readRecordComponent(reader, visitor, node);
                    }
                    break;
                }
                case "Module": {
                    String name = this.readModule(reader.pointer());
                    int access = this.readShort(reader.pointer() + 2);
                    String version = this.readUtf8(reader.pointer() + 4);
                    reader.skip(6);
                    if (name == null) break;
                    ModuleNode moduleNode = node.module;
                    if (moduleNode == null) {
                        moduleNode = new ModuleNode(name, access, version);
                    }
                    this.readModule(reader, visitor.visitModule(name, access, version), moduleNode);
                    break;
                }
                default: {
                    if (!attributeName.startsWith("Custom")) break;
                    if (reader.readByte() != 0) {
                        visitor.visitCustomAttribute(attributeName.substring(6), Arrays.copyOfRange(this.contents, reader.pointer(), reader.pointer() + attributeLength - 1));
                        break;
                    }
                    visitor.visitCustomAttribute(attributeName.substring(6), null);
                }
            }
            reader.pointer(endPos);
        }
        visitor.visitFields(this.memberNamePatchReader.readPatch(reader, node.fields != null ? MemberName.fromFields(node.fields) : Collections.emptyList()));
        int l = reader.readShort();
        for (i = 0; i < l; ++i) {
            this.readField(reader, visitor, node);
        }
        visitor.visitMethods(this.memberNamePatchReader.readPatch(reader, node.methods != null ? MemberName.fromMethods(node.methods) : Collections.emptyList()));
        l = reader.readShort();
        for (i = 0; i < l; ++i) {
            this.readMethod(reader, visitor, node);
        }
        visitor.visitEnd();
        this.context.remove();
    }

    private void readMethod(ByteReader reader, DiffVisitor diffVisitor, ClassNode classNode) {
        int access = reader.readInt();
        String name = this.readUtf8(reader.pointer());
        String descriptor = this.readUtf8(reader.pointer() + 2);
        String signature = this.readUtf8(reader.pointer() + 4);
        reader.skip(6);
        MethodNode node = null;
        if (classNode.methods != null) {
            for (MethodNode test : classNode.methods) {
                if (!test.name.equals(name) || !test.desc.equals(descriptor)) continue;
                node = test;
                break;
            }
        }
        if (node == null) {
            node = new MethodNode(access, name, descriptor, signature, null);
        }
        Patch<String> exceptions = this.classPatchReader.readPatch(reader, Util.nullToEmpty(node.exceptions));
        MethodDiffVisitor visitor = diffVisitor.visitMethod(access, name, descriptor, signature, exceptions);
        int attrCount = reader.readShort();
        for (int i = 0; i < attrCount; ++i) {
            reader.skip(2);
            int attrLength = reader.readInt();
            int endPos = reader.pointer() + attrLength;
            if (visitor != null) {
                String attrName = this.readUtf8(reader.pointer() - 6);
                if (attrName == null) {
                    throw new IllegalArgumentException("null attribute name at address " + Integer.toHexString(reader.pointer() - 6));
                }
                switch (attrName) {
                    case "VisibleAnnotations": {
                        visitor.visitAnnotations(this.annotationPatchReader.readPatch(reader, Util.nullToEmpty(node.visibleAnnotations)), true);
                        break;
                    }
                    case "InvisibleAnnotations": {
                        visitor.visitAnnotations(this.annotationPatchReader.readPatch(reader, Util.nullToEmpty(node.invisibleAnnotations)), false);
                        break;
                    }
                    case "VisibleTypeAnnotations": {
                        visitor.visitTypeAnnotations(this.typeAnnotationPatchReader.readPatch(reader, Util.nullToEmpty(node.visibleTypeAnnotations)), true);
                        break;
                    }
                    case "InvisibleTypeAnnotations": {
                        visitor.visitTypeAnnotations(this.typeAnnotationPatchReader.readPatch(reader, Util.nullToEmpty(node.invisibleTypeAnnotations)), false);
                        break;
                    }
                    case "AnnotationDefault": {
                        if (attrLength > 0) {
                            AnnotationNode annotationNode = new AnnotationNode("");
                            this.readElementValue((AnnotationVisitor)annotationNode, reader.pointer(), null);
                            visitor.visitAnnotationDefault(annotationNode.values.get(1));
                            break;
                        }
                        visitor.visitAnnotationDefault(null);
                        break;
                    }
                    case "VisibleParameterAnnotations": {
                        int j;
                        int annotableCount = reader.readByte();
                        int paramCount = Type.getArgumentTypes((String)descriptor).length;
                        ArrayList<Patch<AnnotationNode>> patches = new ArrayList<Patch<AnnotationNode>>(paramCount);
                        for (j = 0; j < paramCount; ++j) {
                            patches.add(this.annotationPatchReader.readPatch(reader, Util.getListFromArray(node.visibleParameterAnnotations, j)));
                        }
                        visitor.visitParameterAnnotations(annotableCount, patches, true);
                        break;
                    }
                    case "InvisibleParameterAnnotations": {
                        int j;
                        int annotableCount = reader.readByte();
                        int paramCount = Type.getArgumentTypes((String)descriptor).length;
                        ArrayList<Patch<AnnotationNode>> patches = new ArrayList<Patch<AnnotationNode>>(paramCount);
                        for (j = 0; j < paramCount; ++j) {
                            patches.add(this.annotationPatchReader.readPatch(reader, Util.getListFromArray(node.invisibleParameterAnnotations, j)));
                        }
                        visitor.visitParameterAnnotations(annotableCount, patches, false);
                        break;
                    }
                    case "MethodParameters": {
                        visitor.visitParameters(new PatchReader<ParameterNode>(reader1 -> {
                            reader1.skip(2);
                            return new ParameterNode(this.readUtf8(reader1.pointer() - 2), reader1.readInt());
                        }).readPatch(reader, Util.nullToEmpty(node.parameters)));
                        break;
                    }
                    case "Maxs": {
                        visitor.visitMaxs(reader.readShort(), reader.readShort());
                        break;
                    }
                    case "Insns": {
                        int unpatchedInsnCount = reader.readShort();
                        Patch<AbstractInsnNode> patch = new PatchReader<AbstractInsnNode>(this::readInsn).readPatch(reader, new InsnListAdapter(node.instructions));
                        MethodNode fNode = node;
                        visitor.visitInsns(unpatchedInsnCount, patch, Util.lazy(() -> {
                            HashMap<LabelNode, LabelNode> clonedLabels = new HashMap<LabelNode, LabelNode>();
                            for (Object insn : fNode.instructions) {
                                if (!(insn instanceof LabelNode)) continue;
                                clonedLabels.put((LabelNode)insn, new LabelNode());
                            }
                            ArrayList<AbstractInsnNode> clonedInsns = new ArrayList<AbstractInsnNode>(fNode.instructions.size());
                            for (AbstractInsnNode insn : fNode.instructions) {
                                clonedInsns.add(insn.clone(clonedLabels));
                            }
                            InsnList newInsns = Util.asInsnList(Util.applyPatchUnchecked(patch, clonedInsns));
                            return new LabelMap((Iterable<AbstractInsnNode>)newInsns);
                        }));
                        break;
                    }
                    case "LocalVariables": {
                        int nLocals = reader.readShort();
                        ArrayList<LocalVariableNode> locals = new ArrayList<LocalVariableNode>(nLocals);
                        for (int j = 0; j < nLocals; ++j) {
                            reader.skip(6);
                            locals.add(new LocalVariableNode(this.readUtf8(reader.pointer() - 6), this.readUtf8(reader.pointer() - 4), this.readUtf8(reader.pointer() - 2), (LabelNode)new SyntheticLabelNode(reader.readShort()), (LabelNode)new SyntheticLabelNode(reader.readShort()), reader.readShort()));
                        }
                        visitor.visitLocalVariables(locals, null);
                        break;
                    }
                    case "TryCatchBlocks": {
                        int k;
                        int nBlocks = reader.readShort();
                        ArrayList<TryCatchBlockNode> blocks = new ArrayList<TryCatchBlockNode>(nBlocks);
                        for (int j = 0; j < nBlocks; ++j) {
                            int visibleAnnotationCount;
                            TryCatchBlockNode block = new TryCatchBlockNode((LabelNode)new SyntheticLabelNode(reader.readShort()), (LabelNode)new SyntheticLabelNode(reader.readShort()), (LabelNode)new SyntheticLabelNode(reader.readShort()), this.readClass(reader.pointer()));
                            reader.skip(2);
                            int invisibleAnnotationCount = reader.readShort();
                            if (invisibleAnnotationCount > 0) {
                                block.invisibleTypeAnnotations = new ArrayList(invisibleAnnotationCount);
                                for (int k2 = 0; k2 < invisibleAnnotationCount; ++k2) {
                                    block.invisibleTypeAnnotations.add(this.readTypeAnnotation(reader));
                                }
                            }
                            if ((visibleAnnotationCount = reader.readShort()) > 0) {
                                block.visibleTypeAnnotations = new ArrayList(visibleAnnotationCount);
                                for (k = 0; k < visibleAnnotationCount; ++k) {
                                    block.visibleTypeAnnotations.add(this.readTypeAnnotation(reader));
                                }
                            }
                            blocks.add(block);
                        }
                        visitor.visitTryCatchBlocks(blocks, null);
                        break;
                    }
                    case "InvisibleLocalVariableAnnotations": 
                    case "VisibleLocalVariableAnnotations": {
                        int k;
                        int count = reader.readShort();
                        ArrayList<LocalVariableAnnotationNode> annotations = new ArrayList<LocalVariableAnnotationNode>(count);
                        for (int j = 0; j < count; ++j) {
                            TypeAnnotationNode typeAnnotation = this.readTypeAnnotation(reader);
                            int startCount = reader.readShort();
                            LabelNode[] start = new LabelNode[startCount];
                            for (k = 0; k < startCount; ++k) {
                                start[k] = new SyntheticLabelNode(reader.readShort());
                            }
                            int endCount = reader.readShort();
                            LabelNode[] end = new LabelNode[endCount];
                            for (int k3 = 0; k3 < endCount; ++k3) {
                                end[k3] = new SyntheticLabelNode(reader.readShort());
                            }
                            int indexCount = reader.readShort();
                            int[] index = new int[indexCount];
                            for (int k4 = 0; k4 < indexCount; ++k4) {
                                index[k4] = reader.readShort();
                            }
                            annotations.add(new LocalVariableAnnotationNode(typeAnnotation.typeRef, typeAnnotation.typePath, start, end, index, typeAnnotation.desc));
                            ((LocalVariableAnnotationNode)annotations.get((int)j)).values = typeAnnotation.values;
                        }
                        visitor.visitLocalVariableAnnotations(annotations, !attrName.startsWith("In"), null);
                        break;
                    }
                    case "InvisibleInsnAnnotations": 
                    case "VisibleInsnAnnotations": {
                        int j;
                        int nAnnotations = reader.readShort();
                        int[] indices = new int[nAnnotations];
                        ArrayList<TypeAnnotationNode> annotations = new ArrayList<TypeAnnotationNode>(nAnnotations);
                        for (j = 0; j < nAnnotations; ++j) {
                            indices[j] = reader.readShort();
                            annotations.add(this.readTypeAnnotation(reader));
                        }
                        visitor.visitInsnAnnotations(indices, annotations, !attrName.startsWith("In"));
                        break;
                    }
                    default: {
                        if (!attrName.startsWith("Custom")) break;
                        if (reader.readByte() != 0) {
                            visitor.visitCustomAttribute(attrName.substring(6), Arrays.copyOfRange(this.contents, reader.pointer(), reader.pointer() + attrLength - 1));
                            break;
                        }
                        visitor.visitCustomAttribute(attrName.substring(6), null);
                    }
                }
            }
            reader.pointer(endPos);
        }
    }

    private void readField(ByteReader reader, DiffVisitor diffVisitor, ClassNode classNode) {
        int access = reader.readInt();
        String name = this.readUtf8(reader.pointer());
        String descriptor = this.readUtf8(reader.pointer() + 2);
        String signature = this.readUtf8(reader.pointer() + 4);
        reader.skip(6);
        int constantValueIndex = reader.readShort();
        Object constantValue = constantValueIndex != 0 ? this.readConst(constantValueIndex) : null;
        FieldDiffVisitor visitor = diffVisitor.visitField(access, name, descriptor, signature, constantValue);
        FieldNode node = null;
        if (visitor != null) {
            if (classNode.fields != null) {
                for (FieldNode test : classNode.fields) {
                    if (!test.name.equals(name) || !test.desc.equals(descriptor)) continue;
                    node = test;
                    break;
                }
            }
            if (node == null) {
                node = new FieldNode(access, name, descriptor, signature, constantValue);
            }
        }
        int attrCount = reader.readShort();
        for (int i = 0; i < attrCount; ++i) {
            reader.skip(2);
            int attrLength = reader.readInt();
            int endPos = reader.pointer() + attrLength;
            if (visitor != null) {
                String attrName = this.readUtf8(reader.pointer() - 6);
                if (attrName == null) {
                    throw new IllegalArgumentException("null attribute name at address " + Integer.toHexString(reader.pointer() - 6));
                }
                switch (attrName) {
                    case "VisibleAnnotations": {
                        visitor.visitAnnotations(this.annotationPatchReader.readPatch(reader, Util.nullToEmpty(node.visibleAnnotations)), true);
                        break;
                    }
                    case "InvisibleAnnotations": {
                        visitor.visitAnnotations(this.annotationPatchReader.readPatch(reader, Util.nullToEmpty(node.invisibleAnnotations)), false);
                        break;
                    }
                    case "VisibleTypeAnnotations": {
                        visitor.visitTypeAnnotations(this.typeAnnotationPatchReader.readPatch(reader, Util.nullToEmpty(node.visibleTypeAnnotations)), true);
                        break;
                    }
                    case "InvisibleTypeAnnotations": {
                        visitor.visitTypeAnnotations(this.typeAnnotationPatchReader.readPatch(reader, Util.nullToEmpty(node.invisibleTypeAnnotations)), false);
                        break;
                    }
                    default: {
                        if (!attrName.startsWith("Custom")) break;
                        if (reader.readByte() != 0) {
                            visitor.visitCustomAttribute(attrName.substring(6), Arrays.copyOfRange(this.contents, reader.pointer(), reader.pointer() + attrLength - 1));
                            break;
                        }
                        visitor.visitCustomAttribute(attrName.substring(6), null);
                    }
                }
            }
            reader.pointer(endPos);
        }
    }

    private void readModule(ByteReader reader, ModuleDiffVisitor visitor, ModuleNode node) {
        if (visitor == null) {
            return;
        }
        int attrCount = reader.readShort();
        for (int i = 0; i < attrCount; ++i) {
            String attrName = this.readUtf8(reader.pointer());
            if (attrName == null) {
                throw new IllegalArgumentException("null attribute name at address " + Integer.toHexString(reader.pointer()));
            }
            reader.skip(2);
            int attrLen = reader.readInt();
            int endPos = reader.pointer() + attrLen;
            switch (attrName) {
                case "MainClass": {
                    visitor.visitMainClass(this.readClass(reader.pointer()));
                    break;
                }
                case "Packages": {
                    visitor.visitPackages(this.packagePatchReader.readPatch(reader, Util.nullToEmpty(node.packages)));
                    break;
                }
                case "Requires": {
                    visitor.visitRequires(new PatchReader<ModuleRequireNode>(reader1 -> {
                        reader1.skip(6);
                        return new ModuleRequireNode(this.readModule(reader1.pointer() - 6), this.readShort(reader1.pointer() - 4), this.readUtf8(reader1.pointer() - 2));
                    }).readPatch(reader, Util.nullToEmpty(node.requires)));
                    break;
                }
                case "Exports": {
                    visitor.visitExports(new PatchReader<ModuleExportNode>(reader1 -> {
                        String exports = this.readPackage(reader1.pointer());
                        reader1.skip(2);
                        int exportsFlags = reader1.readShort();
                        ArrayList<String> exportsTo = new ArrayList<String>();
                        int l = reader1.readShort();
                        for (int j = 0; j < l; ++j) {
                            exportsTo.add(this.readModule(reader1.pointer()));
                            reader1.skip(2);
                        }
                        return new ModuleExportNode(exports, exportsFlags, exportsTo);
                    }).readPatch(reader, Util.nullToEmpty(node.exports)));
                    break;
                }
                case "Opens": {
                    visitor.visitOpens(new PatchReader<ModuleOpenNode>(reader1 -> {
                        String opens = this.readPackage(reader1.pointer());
                        reader1.skip(2);
                        int opensFlags = reader1.readShort();
                        ArrayList<String> opensTo = new ArrayList<String>();
                        int l = reader1.readShort();
                        for (int j = 0; j < l; ++j) {
                            opensTo.add(this.readModule(reader1.pointer()));
                            reader1.skip(2);
                        }
                        return new ModuleOpenNode(opens, opensFlags, opensTo);
                    }).readPatch(reader, Util.nullToEmpty(node.opens)));
                    break;
                }
                case "Uses": {
                    visitor.visitUses(this.classPatchReader.readPatch(reader, Util.nullToEmpty(node.uses)));
                    break;
                }
                case "Provides": {
                    visitor.visitProvides(new PatchReader<ModuleProvideNode>(reader1 -> {
                        String provides = this.readClass(reader1.pointer());
                        reader1.skip(2);
                        ArrayList<String> providesWith = new ArrayList<String>();
                        int l = reader1.readShort();
                        for (int j = 0; j < l; ++j) {
                            providesWith.add(this.readClass(reader1.pointer()));
                            reader1.skip(2);
                        }
                        return new ModuleProvideNode(provides, providesWith);
                    }).readPatch(reader, Util.nullToEmpty(node.provides)));
                }
            }
            reader.pointer(endPos);
        }
        visitor.visitEnd();
    }

    private void readRecordComponent(ByteReader reader, DiffVisitor diffVisitor, ClassNode classNode) {
        String name = this.readUtf8(reader.pointer());
        String descriptor = this.readUtf8(reader.pointer() + 2);
        String signature = this.readUtf8(reader.pointer() + 4);
        reader.skip(6);
        RecordComponentDiffVisitor visitor = diffVisitor.visitRecordComponent(name, descriptor, signature);
        RecordComponentNode node = null;
        if (visitor != null) {
            if (classNode.recordComponents != null) {
                for (RecordComponentNode test : classNode.recordComponents) {
                    if (!test.name.equals(name) || !test.descriptor.equals(descriptor)) continue;
                    node = test;
                    break;
                }
            }
            if (node == null) {
                node = new RecordComponentNode(name, descriptor, signature);
            }
        }
        int attributeCount = reader.readShort();
        for (int i = 0; i < attributeCount; ++i) {
            reader.skip(2);
            int attrLength = reader.readInt();
            int endPos = reader.pointer() + attrLength;
            if (visitor != null) {
                String attrName = this.readUtf8(reader.pointer() - 6);
                if (attrName == null) {
                    throw new IllegalArgumentException("null attribute name at address " + Integer.toHexString(reader.pointer() - 6));
                }
                switch (attrName) {
                    case "VisibleAnnotations": {
                        visitor.visitAnnotations(this.annotationPatchReader.readPatch(reader, Util.nullToEmpty(node.visibleAnnotations)), true);
                        break;
                    }
                    case "InvisibleAnnotations": {
                        visitor.visitAnnotations(this.annotationPatchReader.readPatch(reader, Util.nullToEmpty(node.invisibleAnnotations)), false);
                        break;
                    }
                    case "VisibleTypeAnnotations": {
                        visitor.visitTypeAnnotations(this.typeAnnotationPatchReader.readPatch(reader, Util.nullToEmpty(node.visibleTypeAnnotations)), true);
                        break;
                    }
                    case "InvisibleTypeAnnotations": {
                        visitor.visitTypeAnnotations(this.typeAnnotationPatchReader.readPatch(reader, Util.nullToEmpty(node.invisibleTypeAnnotations)), false);
                        break;
                    }
                    default: {
                        if (!attrName.startsWith("Custom")) break;
                        if (reader.readByte() != 0) {
                            visitor.visitCustomAttribute(attrName.substring(6), Arrays.copyOfRange(this.contents, reader.pointer(), reader.pointer() + attrLength - 1));
                            break;
                        }
                        visitor.visitCustomAttribute(attrName.substring(6), null);
                    }
                }
            }
            reader.pointer(endPos);
        }
        if (visitor != null) {
            visitor.visitEnd();
        }
    }

    private int readInt(int offset) {
        return (this.contents[offset] & 0xFF) << 24 | (this.contents[offset + 1] & 0xFF) << 16 | (this.contents[offset + 2] & 0xFF) << 8 | this.contents[offset + 3] & 0xFF;
    }

    private int readShort(int offset) {
        return (this.contents[offset] & 0xFF) << 8 | this.contents[offset + 1] & 0xFF;
    }

    private String readClass(int offset) {
        return this.readStringish(offset);
    }

    private String readModule(int offset) {
        return this.readStringish(offset);
    }

    private String readPackage(int offset) {
        return this.readStringish(offset);
    }

    private String readStringish(int offset) {
        return this.readUtf8(this.constantOffsets[this.readShort(offset)]);
    }

    private String readUtf8(int offset) {
        int constantIndex = this.readShort(offset);
        if (offset == 0 || constantIndex == 0) {
            return null;
        }
        return this.readUtf(constantIndex);
    }

    private String readUtf(int constantIndex) {
        String result = this.constantStringCache[constantIndex];
        if (result != null) {
            return result;
        }
        int offset = this.constantOffsets[constantIndex];
        this.constantStringCache[constantIndex] = this.readUtf(offset + 2, this.readShort(offset));
        return this.constantStringCache[constantIndex];
    }

    private String readUtf(int utfOffset, int utfLength) {
        char[] charBuffer = this.charBuffer;
        int currentOffset = utfOffset;
        int endOffset = currentOffset + utfLength;
        int strLength = 0;
        byte[] input = this.contents;
        while (currentOffset < endOffset) {
            byte currentByte;
            if (((currentByte = input[currentOffset++]) & 0x80) == 0) {
                charBuffer[strLength++] = (char)(currentByte & 0x7F);
                continue;
            }
            if ((currentByte & 0xE0) == 192) {
                charBuffer[strLength++] = (char)(((currentByte & 0x1F) << 6) + (input[currentOffset++] & 0x3F));
                continue;
            }
            charBuffer[strLength++] = (char)(((currentByte & 0xF) << 12) + ((input[currentOffset++] & 0x3F) << 6) + (input[currentOffset++] & 0x3F));
        }
        return new String(charBuffer, 0, strLength);
    }

    private int readElementValues(AnnotationVisitor annotationVisitor, int currentOffset, boolean named) {
        int numElementValuePairs = this.readShort(currentOffset);
        currentOffset += 2;
        if (named) {
            while (numElementValuePairs-- > 0) {
                String elementName = this.readUtf8(currentOffset);
                currentOffset = this.readElementValue(annotationVisitor, currentOffset + 2, elementName);
            }
        } else {
            while (numElementValuePairs-- > 0) {
                currentOffset = this.readElementValue(annotationVisitor, currentOffset, null);
            }
        }
        annotationVisitor.visitEnd();
        return currentOffset;
    }

    private int readElementValue(AnnotationVisitor annotationVisitor, int currentOffset, String elementName) {
        block0 : switch (this.contents[currentOffset++] & 0xFF) {
            case 66: {
                annotationVisitor.visit(elementName, (Object)((byte)this.readInt(this.constantOffsets[this.readShort(currentOffset)])));
                currentOffset += 2;
                break;
            }
            case 67: {
                annotationVisitor.visit(elementName, (Object)Character.valueOf((char)this.readInt(this.constantOffsets[this.readShort(currentOffset)])));
                currentOffset += 2;
                break;
            }
            case 68: 
            case 70: 
            case 73: 
            case 74: {
                annotationVisitor.visit(elementName, this.readConst(this.readShort(currentOffset)));
                currentOffset += 2;
                break;
            }
            case 83: {
                annotationVisitor.visit(elementName, (Object)((short)this.readInt(this.constantOffsets[this.readShort(currentOffset)])));
                currentOffset += 2;
                break;
            }
            case 90: {
                annotationVisitor.visit(elementName, (Object)(this.readInt(this.constantOffsets[this.readShort(currentOffset)]) != 0 ? 1 : 0));
                currentOffset += 2;
                break;
            }
            case 115: {
                annotationVisitor.visit(elementName, (Object)this.readUtf8(currentOffset));
                currentOffset += 2;
                break;
            }
            case 101: {
                annotationVisitor.visitEnum(elementName, this.readUtf8(currentOffset), this.readUtf8(currentOffset + 2));
                currentOffset += 4;
                break;
            }
            case 99: {
                annotationVisitor.visit(elementName, (Object)Type.getType((String)this.readUtf8(currentOffset)));
                currentOffset += 2;
                break;
            }
            case 64: {
                currentOffset = this.readElementValues(annotationVisitor.visitAnnotation(elementName, this.readUtf8(currentOffset)), currentOffset + 2, true);
                break;
            }
            case 91: {
                int numValues = this.readShort(currentOffset);
                currentOffset += 2;
                if (numValues == 0) {
                    return this.readElementValues(annotationVisitor.visitArray(elementName), currentOffset - 2, false);
                }
                switch (this.contents[currentOffset] & 0xFF) {
                    case 66: {
                        byte[] values = new byte[numValues];
                        for (int i = 0; i < numValues; ++i) {
                            values[i] = (byte)this.readInt(this.constantOffsets[this.readShort(currentOffset + 1)]);
                            currentOffset += 3;
                        }
                        annotationVisitor.visit(elementName, (Object)values);
                        break block0;
                    }
                    case 90: {
                        boolean[] values = new boolean[numValues];
                        for (int i = 0; i < numValues; ++i) {
                            values[i] = this.readInt(this.constantOffsets[this.readShort(currentOffset + 2)]) != 0;
                            currentOffset += 3;
                        }
                        annotationVisitor.visit(elementName, (Object)values);
                        break block0;
                    }
                    case 83: {
                        short[] values = new short[numValues];
                        for (int i = 0; i < numValues; ++i) {
                            values[i] = (short)this.readInt(this.constantOffsets[this.readShort(currentOffset + 1)]);
                            currentOffset += 3;
                        }
                        annotationVisitor.visit(elementName, (Object)values);
                        break block0;
                    }
                    case 67: {
                        char[] values = new char[numValues];
                        for (int i = 0; i < numValues; ++i) {
                            values[i] = (char)this.readInt(this.constantOffsets[this.readShort(currentOffset + 1)]);
                            currentOffset += 3;
                        }
                        annotationVisitor.visit(elementName, (Object)values);
                        break block0;
                    }
                    case 73: {
                        int[] values = new int[numValues];
                        for (int i = 0; i < numValues; ++i) {
                            values[i] = this.readInt(this.constantOffsets[this.readShort(currentOffset + 1)]);
                            currentOffset += 3;
                        }
                        annotationVisitor.visit(elementName, (Object)values);
                        break block0;
                    }
                    case 74: {
                        long[] values = new long[numValues];
                        for (int i = 0; i < numValues; ++i) {
                            values[i] = this.readLong(this.constantOffsets[this.readShort(currentOffset + 1)]);
                            currentOffset += 3;
                        }
                        annotationVisitor.visit(elementName, (Object)values);
                        break block0;
                    }
                    case 70: {
                        float[] values = new float[numValues];
                        for (int i = 0; i < numValues; ++i) {
                            values[i] = Float.intBitsToFloat(this.readInt(this.constantOffsets[this.readShort(currentOffset + 1)]));
                            currentOffset += 3;
                        }
                        annotationVisitor.visit(elementName, (Object)values);
                        break block0;
                    }
                    case 68: {
                        double[] values = new double[numValues];
                        for (int i = 0; i < numValues; ++i) {
                            values[i] = Double.longBitsToDouble(this.readLong(this.constantOffsets[this.readShort(currentOffset + 1)]));
                            currentOffset += 3;
                        }
                        annotationVisitor.visit(elementName, (Object)values);
                        break block0;
                    }
                }
                currentOffset = this.readElementValues(annotationVisitor.visitArray(elementName), currentOffset - 2, false);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return currentOffset;
    }

    private Object readConst(int constantPoolEntryIndex) {
        int cpInfoOffset = this.constantOffsets[constantPoolEntryIndex];
        switch (this.contents[cpInfoOffset - 1]) {
            case 3: {
                return this.readInt(cpInfoOffset);
            }
            case 4: {
                return Float.valueOf(Float.intBitsToFloat(this.readInt(cpInfoOffset)));
            }
            case 5: {
                return this.readLong(cpInfoOffset);
            }
            case 6: {
                return Double.longBitsToDouble(this.readLong(cpInfoOffset));
            }
            case 7: {
                return Type.getObjectType((String)this.readUtf8(cpInfoOffset));
            }
            case 8: {
                return this.readUtf8(cpInfoOffset);
            }
            case 16: {
                return Type.getMethodType((String)this.readUtf8(cpInfoOffset));
            }
            case 15: {
                int referenceKind = this.contents[cpInfoOffset] & 0xFF;
                int referenceCpInfoOffset = this.constantOffsets[this.readShort(cpInfoOffset + 1)];
                int nameAndTypeCpInfoOffset = this.constantOffsets[this.readShort(referenceCpInfoOffset + 2)];
                String owner = this.readClass(referenceCpInfoOffset);
                String name = this.readUtf8(nameAndTypeCpInfoOffset);
                String descriptor = this.readUtf8(nameAndTypeCpInfoOffset + 2);
                boolean isInterface = this.contents[referenceCpInfoOffset - 1] == 11;
                return new Handle(referenceKind, owner, name, descriptor, isInterface);
            }
            case 17: {
                return this.readConstantDynamic(constantPoolEntryIndex);
            }
        }
        throw new IllegalArgumentException("Unsupported constant pool tag: " + (this.contents[cpInfoOffset - 1] & 0xFF));
    }

    private long readLong(int offset) {
        return ((long)this.readInt(offset) & 0xFFFFFFFFL) << 32 | (long)this.readInt(offset + 4) & 0xFFFFFFFFL;
    }

    private int getFirstAttributeOffset() {
        int deltaCount = this.readShort(this.startPos + 14);
        int offset = this.startPos + 16;
        block6: for (int i = 0; i < deltaCount; ++i) {
            switch (DeltaType.values()[this.contents[offset++]]) {
                case CHANGE: {
                    offset += 6 + 2 * this.readShort(offset + 4);
                    continue block6;
                }
                case DELETE: {
                    offset += 4;
                    continue block6;
                }
                case INSERT: {
                    offset += 4 + 2 * this.readShort(offset + 2);
                    continue block6;
                }
                case EQUAL: {
                    continue block6;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
        }
        return offset + 2;
    }

    private int[] readBsmAttribute() {
        int currentAttributeOffset = this.getFirstAttributeOffset();
        for (int i = this.readShort(currentAttributeOffset - 2); i > 0; --i) {
            String attrName = this.readUtf8(currentAttributeOffset);
            int attrLength = this.readInt(currentAttributeOffset + 2);
            currentAttributeOffset += 6;
            if ("BootstrapMethods".equals(attrName)) {
                int[] result = new int[this.readShort(currentAttributeOffset)];
                int currentBsmOffset = currentAttributeOffset + 2;
                for (int j = 0; j < result.length; ++j) {
                    result[j] = currentBsmOffset;
                    currentBsmOffset += 4 + 2 * this.readShort(currentBsmOffset + 2);
                }
                return result;
            }
            currentAttributeOffset += attrLength;
        }
        throw new IllegalArgumentException();
    }

    private ConstantDynamic readConstantDynamic(int constantPoolEntryIndex) {
        ConstantDynamic result = this.condyCache[constantPoolEntryIndex];
        if (result != null) {
            return result;
        }
        int cpInfoOffset = this.constantOffsets[constantPoolEntryIndex];
        int nameAndTypeCpInfoOffset = this.constantOffsets[this.readShort(cpInfoOffset + 2)];
        String name = this.readUtf8(nameAndTypeCpInfoOffset);
        String descriptor = this.readUtf8(nameAndTypeCpInfoOffset + 2);
        int bootstrapMethodOffset = this.bsmOffsets[this.readShort(cpInfoOffset)];
        Handle handle = (Handle)this.readConst(this.readShort(bootstrapMethodOffset));
        Object[] bootstrapMethodArguments = new Object[this.readShort(bootstrapMethodOffset + 2)];
        bootstrapMethodOffset += 4;
        for (int i = 0; i < bootstrapMethodArguments.length; ++i) {
            bootstrapMethodArguments[i] = this.readConst(this.readShort(bootstrapMethodOffset));
            bootstrapMethodOffset += 2;
        }
        this.condyCache[constantPoolEntryIndex] = new ConstantDynamic(name, descriptor, handle, bootstrapMethodArguments);
        return this.condyCache[constantPoolEntryIndex];
    }

    private int readTypeAnnotationTarget(int typeAnnotationOffset, Context context) {
        int currentOffset = typeAnnotationOffset;
        int targetType = this.readInt(typeAnnotationOffset);
        switch (targetType >>> 24) {
            case 0: 
            case 1: 
            case 22: {
                targetType &= 0xFFFF0000;
                currentOffset += 2;
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 64: 
            case 65: {
                targetType &= 0xFF000000;
                ++currentOffset;
                break;
            }
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: {
                targetType &= 0xFF0000FF;
                currentOffset += 4;
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 23: 
            case 66: {
                targetType &= 0xFFFFFF00;
                currentOffset += 3;
                break;
            }
            case 67: 
            case 68: 
            case 69: 
            case 70: {
                targetType &= 0xFF000000;
                currentOffset += 3;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        context.currentTypeAnnotationTarget = targetType;
        int pathLength = this.contents[currentOffset] & 0xFF;
        context.currentTypeAnnotationTargetPath = pathLength == 0 ? null : ReflectUtils.newTypePath(this.contents, currentOffset);
        return currentOffset + 1 + 2 * pathLength;
    }

    private Label readLabel(int bytecodeOffset, Label[] labels) {
        if (labels[bytecodeOffset] == null) {
            labels[bytecodeOffset] = new Label();
        }
        return labels[bytecodeOffset];
    }

    private Label createLabel(int bytecodeOffset, Label[] labels) {
        return this.readLabel(bytecodeOffset, labels);
    }

    private AbstractInsnNode readInsn(ByteReader reader) {
        int opcode = reader.readByte();
        switch (opcode) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: 
            case 177: 
            case 190: 
            case 191: 
            case 194: 
            case 195: {
                return new InsnNode(opcode);
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                int id = opcode - 26;
                return new VarInsnNode(21 + (id >> 2), id & 3);
            }
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: {
                int id = opcode - 59;
                return new VarInsnNode(54 + (id >> 2), id & 3);
            }
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 198: 
            case 199: {
                return new JumpInsnNode(opcode, (LabelNode)new SyntheticLabelNode(reader.readShort()));
            }
            case 200: 
            case 201: {
                return new JumpInsnNode(opcode - 200 + 167, (LabelNode)new SyntheticLabelNode(reader.readInt()));
            }
            case 196: {
                int secondary = reader.readInt();
                if (secondary == 132) {
                    return new IincInsnNode(reader.readShort(), (int)((short)reader.readShort()));
                }
                return new VarInsnNode(opcode, reader.readShort());
            }
            case 170: {
                SyntheticLabelNode defaultLabel = new SyntheticLabelNode(reader.readInt());
                int low = reader.readInt();
                int high = reader.readInt();
                LabelNode[] table = new LabelNode[high - low + 1];
                for (int i = 0; i < table.length; ++i) {
                    table[i] = new SyntheticLabelNode(reader.readInt());
                }
                return new TableSwitchInsnNode(low, high, (LabelNode)defaultLabel, table);
            }
            case 171: {
                SyntheticLabelNode defaultLabel = new SyntheticLabelNode(reader.readInt());
                int numPairs = reader.readInt();
                int[] keys = new int[numPairs];
                LabelNode[] values = new LabelNode[numPairs];
                for (int i = 0; i < numPairs; ++i) {
                    keys[i] = reader.readInt();
                    values[i] = new SyntheticLabelNode(reader.readInt());
                }
                return new LookupSwitchInsnNode((LabelNode)defaultLabel, keys, values);
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 169: {
                return new VarInsnNode(opcode, reader.readByte());
            }
            case 16: 
            case 188: {
                return new IntInsnNode(opcode, (int)((byte)reader.readByte()));
            }
            case 17: {
                return new IntInsnNode(opcode, (int)((short)reader.readShort()));
            }
            case 18: {
                return new LdcInsnNode(this.readConst(reader.readByte()));
            }
            case 19: 
            case 20: {
                if (opcode == 20) {
                    throw new IllegalArgumentException("ldc2_w instruction is unsupported. ClassDiff uses plain ldc or ldc_w here.");
                }
                return new LdcInsnNode(this.readConst(reader.readShort()));
            }
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 182: 
            case 183: 
            case 184: 
            case 185: {
                int cpInfoOffset = this.constantOffsets[reader.readShort()];
                int nameAndTypeOffset = this.constantOffsets[this.readShort(cpInfoOffset + 2)];
                String owner = this.readClass(cpInfoOffset);
                String name = this.readUtf8(nameAndTypeOffset);
                String descriptor = this.readUtf8(nameAndTypeOffset + 2);
                if (opcode < 182) {
                    return new FieldInsnNode(opcode, owner, name, descriptor);
                }
                return new MethodInsnNode(opcode, owner, name, descriptor, this.contents[cpInfoOffset - 1] == 11);
            }
            case 186: {
                int cpInfoOffset = this.constantOffsets[reader.readShort()];
                int nameAndTypeOffset = this.constantOffsets[this.readShort(cpInfoOffset + 2)];
                String name = this.readUtf8(nameAndTypeOffset);
                String descriptor = this.readUtf8(nameAndTypeOffset + 2);
                int bsmOffset = this.bsmOffsets[this.readShort(cpInfoOffset)];
                Handle handle = (Handle)this.readConst(this.readShort(bsmOffset));
                Object[] bsmArgs = new Object[this.readShort(bsmOffset + 2)];
                bsmOffset += 4;
                for (int i = 0; i < bsmArgs.length; ++i) {
                    bsmArgs[i] = this.readConst(this.readShort(bsmOffset));
                    bsmOffset += 2;
                }
                return new InvokeDynamicInsnNode(name, descriptor, handle, bsmArgs);
            }
            case 187: 
            case 189: 
            case 192: 
            case 193: {
                reader.skip(2);
                return new TypeInsnNode(opcode, this.readClass(reader.pointer() - 2));
            }
            case 132: {
                return new IincInsnNode(reader.readByte(), (int)((byte)reader.readByte()));
            }
            case 197: {
                reader.skip(2);
                return new MultiANewArrayInsnNode(this.readClass(reader.pointer() - 2), reader.readByte());
            }
            case 255: {
                int specialType = reader.readByte();
                switch (specialType) {
                    case 8: {
                        return new LabelNode();
                    }
                    case 14: {
                        int frameType = reader.readByte();
                        switch (frameType) {
                            case -1: 
                            case 0: {
                                int numLocal = reader.readShort();
                                int numStack = reader.readShort();
                                return new FrameNode(frameType, numLocal, this.readFrameObjects(numLocal, reader), numStack, this.readFrameObjects(numStack, reader));
                            }
                            case 1: {
                                int numLocal = reader.readShort();
                                return new FrameNode(1, numLocal, this.readFrameObjects(numLocal, reader), 0, null);
                            }
                            case 2: {
                                int numLocal = reader.readShort();
                                return new FrameNode(2, numLocal, null, 0, null);
                            }
                            case 3: {
                                return new FrameNode(3, 0, null, 0, null);
                            }
                            case 4: {
                                return new FrameNode(4, 0, null, 0, this.readFrameObjects(1, reader));
                            }
                        }
                        throw new IllegalArgumentException("Unknown frame type " + frameType);
                    }
                    case 15: {
                        return new LineNumberNode(reader.readShort(), (LabelNode)new SyntheticLabelNode(reader.readShort()));
                    }
                }
                throw new IllegalArgumentException("Unknown special insn type " + specialType);
            }
        }
        throw new IllegalArgumentException("Unknown opcode 0x" + Integer.toHexString(opcode));
    }

    private Object[] readFrameObjects(int count, ByteReader reader) {
        Object[] result = new Object[count];
        for (int i = 0; i < count; ++i) {
            result[i] = this.readFrameObject(reader);
        }
        return result;
    }

    private Object readFrameObject(ByteReader reader) {
        int tag = reader.readByte();
        switch (tag) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return tag;
            }
            case 7: {
                reader.skip(2);
                return this.readClass(reader.pointer() - 2);
            }
            case 8: {
                return new SyntheticLabelNode(reader.readShort());
            }
        }
        throw new IllegalArgumentException("Unknown frame object type tag " + tag);
    }

    private TypeAnnotationNode readTypeAnnotation(ByteReader reader) {
        Context context = this.context.get();
        reader.pointer(this.readTypeAnnotationTarget(reader.pointer(), context));
        TypeAnnotationNode result = new TypeAnnotationNode(context.currentTypeAnnotationTarget, context.currentTypeAnnotationTargetPath, this.readUtf8(reader.pointer()));
        reader.pointer(this.readElementValues((AnnotationVisitor)result, reader.pointer() + 2, true));
        return result;
    }
}

