/*
 * Decompiled with CFR 0.152.
 */
package dev.rdh.createunlimited.lib.classdiff;

import dev.rdh.createunlimited.lib.classdiff.UncheckedPatchFailure;
import dev.rdh.createunlimited.lib.classdiff.format.DiffReader;
import dev.rdh.createunlimited.lib.classdiff.format.DiffVisitor;
import dev.rdh.createunlimited.lib.classdiff.format.FieldDiffVisitor;
import dev.rdh.createunlimited.lib.classdiff.format.MethodDiffVisitor;
import dev.rdh.createunlimited.lib.classdiff.format.ModuleDiffVisitor;
import dev.rdh.createunlimited.lib.classdiff.format.RecordComponentDiffVisitor;
import dev.rdh.createunlimited.lib.classdiff.util.LabelMap;
import dev.rdh.createunlimited.lib.classdiff.util.MemberName;
import dev.rdh.createunlimited.lib.classdiff.util.ReflectUtils;
import dev.rdh.createunlimited.lib.classdiff.util.SyntheticLabelNode;
import dev.rdh.createunlimited.lib.classdiff.util.Util;
import dev.rdh.createunlimited.lib.delta.GDiffPatcher;
import dev.rdh.createunlimited.lib.difflib.patch.Patch;
import dev.rdh.createunlimited.lib.difflib.patch.PatchFailedException;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.FrameNode;
import org.objectweb.asm.tree.InnerClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.LocalVariableAnnotationNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.LookupSwitchInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.ModuleExportNode;
import org.objectweb.asm.tree.ModuleNode;
import org.objectweb.asm.tree.ModuleOpenNode;
import org.objectweb.asm.tree.ModuleProvideNode;
import org.objectweb.asm.tree.ModuleRequireNode;
import org.objectweb.asm.tree.ParameterNode;
import org.objectweb.asm.tree.RecordComponentNode;
import org.objectweb.asm.tree.TableSwitchInsnNode;
import org.objectweb.asm.tree.TryCatchBlockNode;
import org.objectweb.asm.tree.TypeAnnotationNode;

public class ClassPatcher
extends DiffVisitor {
    private final GDiffPatcher bytePatcher = new GDiffPatcher();
    private final ClassNode node;

    public ClassPatcher(ClassNode node) {
        this.node = node;
    }

    public static void patch(ClassNode node, DiffReader patch) {
        patch.accept(new ClassPatcher(node), node);
    }

    public static void patch(ClassReader reader, DiffReader patch, ClassVisitor output) {
        ClassNode node = new ClassNode();
        reader.accept((ClassVisitor)node, 0);
        ClassPatcher.patch(node, patch);
        node.accept(output);
    }

    @Override
    public void visit(int diffVersion, int classVersion, int access, @Nullable String name, @Nullable String signature, @Nullable String superName, @Nullable Patch<String> interfaces) {
        if (classVersion != -1) {
            this.node.version = classVersion;
        }
        if (access != -1) {
            this.node.access = access;
        }
        if (name != null) {
            this.node.name = name;
        }
        if (signature != null) {
            String string = this.node.signature = !signature.isEmpty() ? signature : null;
        }
        if (superName != null) {
            String string = this.node.superName = !superName.isEmpty() ? superName : null;
        }
        if (interfaces != null) {
            if (this.node.interfaces == null) {
                this.node.interfaces = Collections.emptyList();
            }
            try {
                this.node.interfaces = interfaces.applyTo(this.node.interfaces);
            }
            catch (PatchFailedException e) {
                throw new UncheckedPatchFailure(e);
            }
        }
    }

    @Override
    public void visitSource(@Nullable String source, @Nullable String debug) {
        if (source != null) {
            this.node.sourceFile = source;
        }
        if (debug != null) {
            this.node.sourceDebug = debug;
        }
    }

    @Override
    public void visitInnerClasses(Patch<InnerClassNode> patch) {
        if (this.node.innerClasses == null) {
            this.node.innerClasses = Collections.emptyList();
        }
        try {
            this.node.innerClasses = patch.applyTo(this.node.innerClasses);
        }
        catch (PatchFailedException e) {
            throw new UncheckedPatchFailure(e);
        }
    }

    @Override
    public void visitOuterClass(@Nullable String className, @Nullable String methodName, @Nullable String methodDescriptor) {
        if (className != null) {
            this.node.outerClass = className;
        }
        if (methodName != null) {
            String string = this.node.outerMethod = !methodName.isEmpty() ? methodName : null;
        }
        if (methodDescriptor != null) {
            this.node.outerMethodDesc = !methodDescriptor.isEmpty() ? methodDescriptor : null;
        }
    }

    @Override
    public void visitNestHost(@Nullable String nestHost) {
        this.node.nestHostClass = nestHost;
    }

    @Override
    public void visitNestMembers(Patch<String> patch) {
        if (this.node.nestMembers == null) {
            this.node.nestMembers = Collections.emptyList();
        }
        try {
            this.node.nestMembers = patch.applyTo(this.node.nestMembers);
        }
        catch (PatchFailedException e) {
            throw new UncheckedPatchFailure(e);
        }
    }

    @Override
    public void visitPermittedSubclasses(Patch<String> patch) {
        if (this.node.permittedSubclasses == null) {
            this.node.permittedSubclasses = Collections.emptyList();
        }
        try {
            this.node.permittedSubclasses = patch.applyTo(this.node.permittedSubclasses);
        }
        catch (PatchFailedException e) {
            throw new UncheckedPatchFailure(e);
        }
    }

    @Override
    public void visitAnnotations(Patch<AnnotationNode> patch, boolean visible) {
        try {
            if (visible) {
                if (this.node.visibleAnnotations == null) {
                    this.node.visibleAnnotations = Collections.emptyList();
                }
                this.node.visibleAnnotations = patch.applyTo(this.node.visibleAnnotations);
            } else {
                if (this.node.invisibleAnnotations == null) {
                    this.node.invisibleAnnotations = Collections.emptyList();
                }
                this.node.invisibleAnnotations = patch.applyTo(this.node.invisibleAnnotations);
            }
        }
        catch (PatchFailedException e) {
            throw new UncheckedPatchFailure(e);
        }
    }

    @Override
    public void visitTypeAnnotations(Patch<TypeAnnotationNode> patch, boolean visible) {
        try {
            if (visible) {
                if (this.node.visibleTypeAnnotations == null) {
                    this.node.visibleTypeAnnotations = Collections.emptyList();
                }
                this.node.visibleTypeAnnotations = patch.applyTo(this.node.visibleTypeAnnotations);
            } else {
                if (this.node.invisibleTypeAnnotations == null) {
                    this.node.invisibleTypeAnnotations = Collections.emptyList();
                }
                this.node.invisibleTypeAnnotations = patch.applyTo(this.node.invisibleTypeAnnotations);
            }
        }
        catch (PatchFailedException e) {
            throw new UncheckedPatchFailure(e);
        }
    }

    @Override
    public void visitRecordComponents(Patch<MemberName> patch) {
        List<MemberName> modifiedList;
        if (patch.getDeltas().isEmpty()) {
            return;
        }
        List<MemberName> originalList = MemberName.fromRecordComponents(this.node.recordComponents);
        try {
            modifiedList = patch.applyTo(originalList);
        }
        catch (PatchFailedException e) {
            throw new UncheckedPatchFailure(e);
        }
        HashMap<MemberName, RecordComponentNode> originalMap = new HashMap<MemberName, RecordComponentNode>();
        for (int i = 0; i < originalList.size(); ++i) {
            originalMap.put(originalList.get(i), (RecordComponentNode)this.node.recordComponents.get(i));
        }
        this.node.recordComponents = new ArrayList();
        for (MemberName name : modifiedList) {
            RecordComponentNode recordNode = (RecordComponentNode)originalMap.get(name);
            if (recordNode == null) {
                recordNode = new RecordComponentNode(name.name, name.descriptor, null);
            }
            this.node.recordComponents.add(recordNode);
        }
    }

    @Override
    @Nullable
    public RecordComponentDiffVisitor visitRecordComponent(String name, String descriptor, @Nullable String signature) {
        if (this.node.recordComponents == null) {
            this.node.recordComponents = new ArrayList();
        }
        RecordComponentNode recordNode = null;
        for (RecordComponentNode test : this.node.recordComponents) {
            if (!test.name.equals(name) || !test.descriptor.equals(descriptor)) continue;
            recordNode = test;
            break;
        }
        if (recordNode == null) {
            recordNode = new RecordComponentNode(name, descriptor, signature);
            this.node.recordComponents.add(recordNode);
        }
        recordNode.signature = signature;
        final RecordComponentNode fRecordNode = recordNode;
        return new RecordComponentDiffVisitor(){

            @Override
            public void visitAnnotations(Patch<AnnotationNode> patch, boolean visible) {
                try {
                    if (visible) {
                        if (fRecordNode.visibleAnnotations == null) {
                            fRecordNode.visibleAnnotations = Collections.emptyList();
                        }
                        fRecordNode.visibleAnnotations = patch.applyTo(fRecordNode.visibleAnnotations);
                    } else {
                        if (fRecordNode.invisibleAnnotations == null) {
                            fRecordNode.invisibleAnnotations = Collections.emptyList();
                        }
                        fRecordNode.invisibleAnnotations = patch.applyTo(fRecordNode.invisibleAnnotations);
                    }
                }
                catch (PatchFailedException e) {
                    throw new UncheckedPatchFailure(e);
                }
            }

            @Override
            public void visitTypeAnnotations(Patch<TypeAnnotationNode> patch, boolean visible) {
                try {
                    if (visible) {
                        if (fRecordNode.visibleTypeAnnotations == null) {
                            fRecordNode.visibleTypeAnnotations = Collections.emptyList();
                        }
                        fRecordNode.visibleTypeAnnotations = patch.applyTo(fRecordNode.visibleTypeAnnotations);
                    } else {
                        if (fRecordNode.invisibleTypeAnnotations == null) {
                            fRecordNode.invisibleTypeAnnotations = Collections.emptyList();
                        }
                        fRecordNode.invisibleTypeAnnotations = patch.applyTo(fRecordNode.invisibleTypeAnnotations);
                    }
                }
                catch (PatchFailedException e) {
                    throw new UncheckedPatchFailure(e);
                }
            }

            @Override
            public void visitCustomAttribute(String name, byte @Nullable [] patchOrContents) {
                if (patchOrContents == null) {
                    fRecordNode.attrs.removeIf(attr -> attr.type.equals(name));
                    return;
                }
                for (Attribute attr2 : fRecordNode.attrs) {
                    byte[] patched;
                    if (!attr2.type.equals(name)) continue;
                    byte[] original = ReflectUtils.getAttributeContent(attr2);
                    try {
                        patched = ClassPatcher.this.bytePatcher.patch(original, patchOrContents);
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                    ReflectUtils.setAttributeContent(attr2, patched);
                    return;
                }
                Attribute attr3 = ReflectUtils.newAttribute(name);
                ReflectUtils.setAttributeContent(attr3, patchOrContents);
                fRecordNode.attrs.add(attr3);
            }
        };
    }

    @Override
    public ModuleDiffVisitor visitModule(@Nullable String name, int access, @Nullable String version) {
        if (name == null) {
            this.node.module = null;
            return null;
        }
        if (this.node.module == null) {
            this.node.module = new ModuleNode(name, access, version);
        } else {
            this.node.module.name = name;
            this.node.module.access = access;
            this.node.module.version = version;
        }
        return new ModuleDiffVisitor(){

            @Override
            public void visitMainClass(@Nullable String mainClass) {
                ((ClassPatcher)ClassPatcher.this).node.module.mainClass = mainClass;
            }

            @Override
            public void visitPackages(Patch<String> patch) {
                if (((ClassPatcher)ClassPatcher.this).node.module.packages == null) {
                    ((ClassPatcher)ClassPatcher.this).node.module.packages = Collections.emptyList();
                }
                try {
                    ((ClassPatcher)ClassPatcher.this).node.module.packages = patch.applyTo(((ClassPatcher)ClassPatcher.this).node.module.packages);
                }
                catch (PatchFailedException e) {
                    throw new UncheckedPatchFailure(e);
                }
            }

            @Override
            public void visitRequires(Patch<ModuleRequireNode> patch) {
                if (((ClassPatcher)ClassPatcher.this).node.module.requires == null) {
                    ((ClassPatcher)ClassPatcher.this).node.module.requires = Collections.emptyList();
                }
                try {
                    ((ClassPatcher)ClassPatcher.this).node.module.requires = patch.applyTo(((ClassPatcher)ClassPatcher.this).node.module.requires);
                }
                catch (PatchFailedException e) {
                    throw new UncheckedPatchFailure(e);
                }
            }

            @Override
            public void visitExports(Patch<ModuleExportNode> patch) {
                if (((ClassPatcher)ClassPatcher.this).node.module.exports == null) {
                    ((ClassPatcher)ClassPatcher.this).node.module.exports = Collections.emptyList();
                }
                try {
                    ((ClassPatcher)ClassPatcher.this).node.module.exports = patch.applyTo(((ClassPatcher)ClassPatcher.this).node.module.exports);
                }
                catch (PatchFailedException e) {
                    throw new UncheckedPatchFailure(e);
                }
            }

            @Override
            public void visitOpens(Patch<ModuleOpenNode> patch) {
                if (((ClassPatcher)ClassPatcher.this).node.module.opens == null) {
                    ((ClassPatcher)ClassPatcher.this).node.module.opens = Collections.emptyList();
                }
                try {
                    ((ClassPatcher)ClassPatcher.this).node.module.opens = patch.applyTo(((ClassPatcher)ClassPatcher.this).node.module.opens);
                }
                catch (PatchFailedException e) {
                    throw new UncheckedPatchFailure(e);
                }
            }

            @Override
            public void visitUses(Patch<String> patch) {
                if (((ClassPatcher)ClassPatcher.this).node.module.uses == null) {
                    ((ClassPatcher)ClassPatcher.this).node.module.uses = Collections.emptyList();
                }
                try {
                    ((ClassPatcher)ClassPatcher.this).node.module.uses = patch.applyTo(((ClassPatcher)ClassPatcher.this).node.module.uses);
                }
                catch (PatchFailedException e) {
                    throw new UncheckedPatchFailure(e);
                }
            }

            @Override
            public void visitProvides(Patch<ModuleProvideNode> patch) {
                if (((ClassPatcher)ClassPatcher.this).node.module.provides == null) {
                    ((ClassPatcher)ClassPatcher.this).node.module.provides = Collections.emptyList();
                }
                try {
                    ((ClassPatcher)ClassPatcher.this).node.module.provides = patch.applyTo(((ClassPatcher)ClassPatcher.this).node.module.provides);
                }
                catch (PatchFailedException e) {
                    throw new UncheckedPatchFailure(e);
                }
            }
        };
    }

    @Override
    public void visitCustomAttribute(String name, byte @Nullable [] patchOrContents) {
        if (patchOrContents == null) {
            this.node.attrs.removeIf(attr -> attr.type.equals(name));
            return;
        }
        for (Attribute attr2 : this.node.attrs) {
            byte[] patched;
            if (!attr2.type.equals(name)) continue;
            byte[] original = ReflectUtils.getAttributeContent(attr2);
            try {
                patched = this.bytePatcher.patch(original, patchOrContents);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            ReflectUtils.setAttributeContent(attr2, patched);
            return;
        }
        Attribute attr3 = ReflectUtils.newAttribute(name);
        ReflectUtils.setAttributeContent(attr3, patchOrContents);
        this.node.attrs.add(attr3);
    }

    @Override
    public void visitFields(Patch<MemberName> patch) {
        List<MemberName> modifiedList;
        if (patch.getDeltas().isEmpty()) {
            return;
        }
        List<MemberName> originalList = MemberName.fromFields(this.node.fields);
        try {
            modifiedList = patch.applyTo(originalList);
        }
        catch (PatchFailedException e) {
            throw new UncheckedPatchFailure(e);
        }
        HashMap<MemberName, FieldNode> originalMap = new HashMap<MemberName, FieldNode>();
        for (int i = 0; i < originalList.size(); ++i) {
            originalMap.put(originalList.get(i), (FieldNode)this.node.fields.get(i));
        }
        this.node.fields = new ArrayList();
        for (MemberName name : modifiedList) {
            FieldNode fieldNode = (FieldNode)originalMap.get(name);
            if (fieldNode == null) {
                fieldNode = new FieldNode(0, name.name, name.descriptor, null, null);
            }
            this.node.fields.add(fieldNode);
        }
    }

    @Override
    @Nullable
    public FieldDiffVisitor visitField(int access, String name, String descriptor, @Nullable String signature, @Nullable Object value) {
        if (this.node.fields == null) {
            this.node.fields = new ArrayList();
        }
        FieldNode fieldNode = null;
        for (FieldNode test : this.node.fields) {
            if (!test.name.equals(name) || !test.desc.equals(descriptor)) continue;
            fieldNode = test;
            break;
        }
        if (fieldNode == null) {
            fieldNode = new FieldNode(access, name, descriptor, signature, value);
            this.node.fields.add(fieldNode);
        }
        fieldNode.access = access;
        fieldNode.signature = signature;
        fieldNode.value = value;
        final FieldNode fFieldNode = fieldNode;
        return new FieldDiffVisitor(){

            @Override
            public void visitAnnotations(Patch<AnnotationNode> patch, boolean visible) {
                try {
                    if (visible) {
                        if (fFieldNode.visibleAnnotations == null) {
                            fFieldNode.visibleAnnotations = Collections.emptyList();
                        }
                        fFieldNode.visibleAnnotations = patch.applyTo(fFieldNode.visibleAnnotations);
                    } else {
                        if (fFieldNode.invisibleAnnotations == null) {
                            fFieldNode.invisibleAnnotations = Collections.emptyList();
                        }
                        fFieldNode.invisibleAnnotations = patch.applyTo(fFieldNode.invisibleAnnotations);
                    }
                }
                catch (PatchFailedException e) {
                    throw new UncheckedPatchFailure(e);
                }
            }

            @Override
            public void visitTypeAnnotations(Patch<TypeAnnotationNode> patch, boolean visible) {
                try {
                    if (visible) {
                        if (fFieldNode.visibleTypeAnnotations == null) {
                            fFieldNode.visibleTypeAnnotations = Collections.emptyList();
                        }
                        fFieldNode.visibleTypeAnnotations = patch.applyTo(fFieldNode.visibleTypeAnnotations);
                    } else {
                        if (fFieldNode.invisibleTypeAnnotations == null) {
                            fFieldNode.invisibleTypeAnnotations = Collections.emptyList();
                        }
                        fFieldNode.invisibleTypeAnnotations = patch.applyTo(fFieldNode.invisibleTypeAnnotations);
                    }
                }
                catch (PatchFailedException e) {
                    throw new UncheckedPatchFailure(e);
                }
            }

            @Override
            public void visitCustomAttribute(String name, byte @Nullable [] patchOrContents) {
                if (patchOrContents == null) {
                    fFieldNode.attrs.removeIf(attr -> attr.type.equals(name));
                    return;
                }
                for (Attribute attr2 : fFieldNode.attrs) {
                    byte[] patched;
                    if (!attr2.type.equals(name)) continue;
                    byte[] original = ReflectUtils.getAttributeContent(attr2);
                    try {
                        patched = ClassPatcher.this.bytePatcher.patch(original, patchOrContents);
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                    ReflectUtils.setAttributeContent(attr2, patched);
                    return;
                }
                Attribute attr3 = ReflectUtils.newAttribute(name);
                ReflectUtils.setAttributeContent(attr3, patchOrContents);
                fFieldNode.attrs.add(attr3);
            }
        };
    }

    @Override
    public void visitMethods(Patch<MemberName> patch) {
        List<MemberName> modifiedList;
        if (patch.getDeltas().isEmpty()) {
            return;
        }
        List<MemberName> originalList = MemberName.fromMethods(this.node.methods);
        try {
            modifiedList = patch.applyTo(originalList);
        }
        catch (PatchFailedException e) {
            throw new UncheckedPatchFailure(e);
        }
        HashMap<MemberName, MethodNode> originalMap = new HashMap<MemberName, MethodNode>();
        for (int i = 0; i < originalList.size(); ++i) {
            originalMap.put(originalList.get(i), (MethodNode)this.node.methods.get(i));
        }
        this.node.methods = new ArrayList();
        for (MemberName name : modifiedList) {
            MethodNode methodNode = (MethodNode)originalMap.get(name);
            if (methodNode == null) {
                methodNode = new MethodNode(0, name.name, name.descriptor, null, null);
            }
            this.node.methods.add(methodNode);
        }
    }

    @Override
    @Nullable
    public MethodDiffVisitor visitMethod(int access, final String name, final String descriptor, @Nullable String signature, Patch<String> exceptions) {
        if (this.node.methods == null) {
            this.node.methods = new ArrayList();
        }
        MethodNode methodNode = null;
        for (MethodNode test : this.node.methods) {
            if (!test.name.equals(name) || !test.desc.equals(descriptor)) continue;
            methodNode = test;
            break;
        }
        if (methodNode == null) {
            methodNode = new MethodNode(access, name, descriptor, signature, null);
            this.node.methods.add(methodNode);
        }
        methodNode.access = access;
        methodNode.signature = signature;
        try {
            methodNode.exceptions = exceptions.applyTo(methodNode.exceptions);
        }
        catch (PatchFailedException e) {
            throw new UncheckedPatchFailure(e);
        }
        final MethodNode fMethodNode = methodNode;
        return new MethodDiffVisitor(){
            boolean insnsFrozen;
            LabelMap insnsLabelMap;

            @Override
            public void visitAnnotations(Patch<AnnotationNode> patch, boolean visible) {
                try {
                    if (visible) {
                        if (fMethodNode.visibleAnnotations == null) {
                            fMethodNode.visibleAnnotations = Collections.emptyList();
                        }
                        fMethodNode.visibleAnnotations = patch.applyTo(fMethodNode.visibleAnnotations);
                    } else {
                        if (fMethodNode.invisibleAnnotations == null) {
                            fMethodNode.invisibleAnnotations = Collections.emptyList();
                        }
                        fMethodNode.invisibleAnnotations = patch.applyTo(fMethodNode.invisibleAnnotations);
                    }
                }
                catch (PatchFailedException e) {
                    throw new UncheckedPatchFailure(e);
                }
            }

            @Override
            public void visitTypeAnnotations(Patch<TypeAnnotationNode> patch, boolean visible) {
                try {
                    if (visible) {
                        if (fMethodNode.visibleTypeAnnotations == null) {
                            fMethodNode.visibleTypeAnnotations = Collections.emptyList();
                        }
                        fMethodNode.visibleTypeAnnotations = patch.applyTo(fMethodNode.visibleTypeAnnotations);
                    } else {
                        if (fMethodNode.invisibleTypeAnnotations == null) {
                            fMethodNode.invisibleTypeAnnotations = Collections.emptyList();
                        }
                        fMethodNode.invisibleTypeAnnotations = patch.applyTo(fMethodNode.invisibleTypeAnnotations);
                    }
                }
                catch (PatchFailedException e) {
                    throw new UncheckedPatchFailure(e);
                }
            }

            @Override
            public void visitAnnotationDefault(@Nullable Object value) {
                fMethodNode.annotationDefault = value;
            }

            @Override
            public void visitParameterAnnotations(int annotableCount, List<Patch<AnnotationNode>> patches, boolean visible) {
                List[] output;
                if (visible) {
                    fMethodNode.visibleAnnotableParameterCount = annotableCount;
                    if (fMethodNode.visibleParameterAnnotations == null) {
                        fMethodNode.visibleParameterAnnotations = new List[patches.size()];
                    }
                    output = fMethodNode.visibleParameterAnnotations;
                } else {
                    fMethodNode.invisibleAnnotableParameterCount = annotableCount;
                    if (fMethodNode.invisibleParameterAnnotations == null) {
                        fMethodNode.invisibleParameterAnnotations = new List[patches.size()];
                    }
                    output = fMethodNode.invisibleParameterAnnotations;
                }
                try {
                    for (int i = 0; i < output.length; ++i) {
                        output[i] = patches.get(i).applyTo(Util.getListFromArray(output, i));
                    }
                }
                catch (PatchFailedException e) {
                    throw new UncheckedPatchFailure(e);
                }
            }

            @Override
            public void visitParameters(Patch<ParameterNode> parameters) {
                if (fMethodNode.parameters == null) {
                    fMethodNode.parameters = Collections.emptyList();
                }
                try {
                    fMethodNode.parameters = parameters.applyTo(fMethodNode.parameters);
                }
                catch (PatchFailedException e) {
                    throw new UncheckedPatchFailure(e);
                }
            }

            @Override
            public void visitCustomAttribute(String name2, byte @Nullable [] patchOrContents) {
                if (patchOrContents == null) {
                    fMethodNode.attrs.removeIf(attr -> attr.type.equals(name2));
                    return;
                }
                for (Attribute attr2 : fMethodNode.attrs) {
                    byte[] patched;
                    if (!attr2.type.equals(name2)) continue;
                    byte[] original = ReflectUtils.getAttributeContent(attr2);
                    try {
                        patched = ClassPatcher.this.bytePatcher.patch(original, patchOrContents);
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                    ReflectUtils.setAttributeContent(attr2, patched);
                    return;
                }
                Attribute attr3 = ReflectUtils.newAttribute(name2);
                ReflectUtils.setAttributeContent(attr3, patchOrContents);
                fMethodNode.attrs.add(attr3);
            }

            @Override
            public void visitMaxs(int maxStack, int maxLocals) {
                fMethodNode.maxStack = maxStack;
                fMethodNode.maxLocals = maxLocals;
            }

            @Override
            public void visitInsns(int unpatchedInsnCount, Patch<AbstractInsnNode> patch, Supplier<LabelMap> patchedLabelMap) {
                LabelMap newLabelMap;
                if (this.insnsFrozen) {
                    throw new IllegalStateException("Cannot call ClassPatcher.visitMethod().visitInsns() after freeze");
                }
                if (unpatchedInsnCount != fMethodNode.instructions.size()) {
                    throw new IllegalArgumentException("Instruction size for " + name + descriptor + " was " + fMethodNode.instructions.size() + ". " + unpatchedInsnCount + " instructions were expected.\nDouble check you are patching the same file the diff is for, and that you are passing the same flags to ClassReader.accept().");
                }
                HashMap<LabelNode, LabelNode> clonedLabels = new HashMap<LabelNode, LabelNode>();
                for (Object insn : fMethodNode.instructions) {
                    if (!(insn instanceof LabelNode)) continue;
                    clonedLabels.put((LabelNode)insn, new LabelNode());
                }
                ArrayList<AbstractInsnNode> clonedInsns = new ArrayList<AbstractInsnNode>(fMethodNode.instructions.size());
                for (AbstractInsnNode insn : fMethodNode.instructions) {
                    clonedInsns.add(insn.clone(clonedLabels));
                }
                InsnList newInsns = Util.asInsnList(Util.applyPatchUnchecked(patch, clonedInsns));
                this.insnsLabelMap = newLabelMap = new LabelMap((Iterable<AbstractInsnNode>)newInsns);
                block9: for (AbstractInsnNode insn : newInsns) {
                    switch (insn.getType()) {
                        case 7: {
                            JumpInsnNode jumpInsn = (JumpInsnNode)insn;
                            jumpInsn.label = newLabelMap.resolve(jumpInsn.label);
                            break;
                        }
                        case 11: {
                            TableSwitchInsnNode tableSwitchInsn = (TableSwitchInsnNode)insn;
                            tableSwitchInsn.dflt = newLabelMap.resolve(tableSwitchInsn.dflt);
                            tableSwitchInsn.labels.replaceAll(newLabelMap::resolve);
                            break;
                        }
                        case 12: {
                            LookupSwitchInsnNode lookupSwitchInsn = (LookupSwitchInsnNode)insn;
                            lookupSwitchInsn.dflt = newLabelMap.resolve(lookupSwitchInsn.dflt);
                            lookupSwitchInsn.labels.replaceAll(newLabelMap::resolve);
                            break;
                        }
                        case 15: {
                            LineNumberNode lineNumber = (LineNumberNode)insn;
                            lineNumber.start = newLabelMap.resolve(lineNumber.start);
                            break;
                        }
                        case 14: {
                            FrameNode frame = (FrameNode)insn;
                            if (frame.stack == null && frame.local == null) break;
                            UnaryOperator replacer = o -> o instanceof LabelNode ? newLabelMap.resolve((LabelNode)o) : o;
                            if (frame.stack != null) {
                                frame.stack.replaceAll(replacer);
                            }
                            if (frame.local == null) continue block9;
                            frame.local.replaceAll(replacer);
                            break;
                        }
                    }
                }
                fMethodNode.instructions = newInsns;
            }

            @Override
            public void visitLocalVariables(List<LocalVariableNode> newLocals, @Nullable LabelMap useMap) {
                if (useMap == null) {
                    useMap = this.insnsLabelMap;
                }
                if (useMap == null) {
                    if (newLocals.stream().anyMatch(l -> l.start instanceof SyntheticLabelNode || l.end instanceof SyntheticLabelNode)) {
                        this.insnsFrozen = true;
                        useMap = new LabelMap((Iterable<AbstractInsnNode>)fMethodNode.instructions);
                    } else {
                        useMap = new LabelMap(new LabelNode[0]);
                    }
                }
                ArrayList<LocalVariableNode> output = new ArrayList<LocalVariableNode>(newLocals.size());
                for (LocalVariableNode local : newLocals) {
                    output.add(new LocalVariableNode(local.name, local.desc, local.signature, useMap.resolve(local.start), useMap.resolve(local.end), local.index));
                }
                fMethodNode.localVariables = output;
            }

            @Override
            public void visitTryCatchBlocks(List<TryCatchBlockNode> newBlocks, @Nullable LabelMap useMap) {
                if (useMap == null) {
                    useMap = this.insnsLabelMap;
                }
                if (useMap == null) {
                    if (newBlocks.stream().anyMatch(l -> l.start instanceof SyntheticLabelNode || l.end instanceof SyntheticLabelNode || l.handler instanceof SyntheticLabelNode)) {
                        this.insnsFrozen = true;
                        useMap = new LabelMap((Iterable<AbstractInsnNode>)fMethodNode.instructions);
                    } else {
                        useMap = new LabelMap(new LabelNode[0]);
                    }
                }
                ArrayList<TryCatchBlockNode> output = new ArrayList<TryCatchBlockNode>(newBlocks.size());
                for (TryCatchBlockNode block : newBlocks) {
                    TryCatchBlockNode newBlock = new TryCatchBlockNode(useMap.resolve(block.start), useMap.resolve(block.end), useMap.resolve(block.handler), block.type);
                    newBlock.invisibleTypeAnnotations = block.invisibleTypeAnnotations;
                    newBlock.visibleTypeAnnotations = block.visibleTypeAnnotations;
                    output.add(newBlock);
                }
                fMethodNode.tryCatchBlocks = output;
            }

            @Override
            public void visitLocalVariableAnnotations(List<LocalVariableAnnotationNode> annotations, boolean visible, @Nullable LabelMap useMap) {
                if (useMap == null) {
                    useMap = this.insnsLabelMap;
                }
                if (useMap == null) {
                    if (annotations.stream().anyMatch(l -> l.start.stream().anyMatch(l2 -> l2 instanceof SyntheticLabelNode) || l.end.stream().anyMatch(l2 -> l2 instanceof SyntheticLabelNode))) {
                        this.insnsFrozen = true;
                        useMap = new LabelMap((Iterable<AbstractInsnNode>)fMethodNode.instructions);
                    } else {
                        useMap = new LabelMap(new LabelNode[0]);
                    }
                }
                ArrayList<LocalVariableAnnotationNode> output = new ArrayList<LocalVariableAnnotationNode>(annotations.size());
                for (LocalVariableAnnotationNode annotation : annotations) {
                    LocalVariableAnnotationNode newAnnotation = new LocalVariableAnnotationNode(0, null, null, null, null, "");
                    newAnnotation.typeRef = annotation.typeRef;
                    newAnnotation.typePath = annotation.typePath;
                    newAnnotation.start = annotation.start.stream().map(useMap::resolve).collect(Collectors.toList());
                    newAnnotation.end = annotation.end.stream().map(useMap::resolve).collect(Collectors.toList());
                    newAnnotation.index = annotation.index;
                    newAnnotation.desc = annotation.desc;
                    output.add(newAnnotation);
                }
                if (visible) {
                    fMethodNode.visibleLocalVariableAnnotations = output;
                } else {
                    fMethodNode.invisibleLocalVariableAnnotations = output;
                }
            }

            @Override
            public void visitInsnAnnotations(int[] indices, List<TypeAnnotationNode> annotations, boolean visible) {
                this.insnsFrozen = true;
                for (int i = 0; i < indices.length; ++i) {
                    AbstractInsnNode insn = fMethodNode.instructions.get(indices[i]);
                    TypeAnnotationNode annotation = annotations.get(i);
                    if (visible) {
                        if (insn.visibleTypeAnnotations == null) {
                            insn.visibleTypeAnnotations = new ArrayList();
                        }
                        insn.visibleTypeAnnotations.add(annotation);
                        continue;
                    }
                    if (insn.invisibleTypeAnnotations == null) {
                        insn.invisibleTypeAnnotations = new ArrayList();
                    }
                    insn.invisibleTypeAnnotations.add(annotation);
                }
            }
        };
    }
}

