/*
 * Decompiled with CFR 0.152.
 */
package dev.rdh.createunlimited.config;

import dev.rdh.createunlimited.CreateUnlimited;
import dev.rdh.createunlimited.Util;
import dev.rdh.createunlimited.config.PlacementCheck;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.createmod.catnip.config.ConfigBase;
import net.createmod.catnip.config.ui.BaseConfigScreen;
import net.minecraft.class_437;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

public class CUConfig
extends ConfigBase {
    public final ConfigBase.ConfigGroup trains = this.group(1, "trains", new String[]{"Realism, what's that?"});
    public final ConfigBase.ConfigEnum<PlacementCheck> placementChecks = this.e(PlacementCheck.ON, "placementChecks", new String[]{"Whether to check for valid placement when placing train tracks"});
    public final ConfigBase.ConfigFloat extendedDriving = this.f(0.875f, 0.0f, 0.875f, "extendedDriving", new String[]{"The minimum turn that trains can drive on. Set to 0.01 if buggy."});
    public final ConfigBase.ConfigFloat maxTrainRelocationDistance = this.f(24.0f, 0.0f, "maxTrainRelocationDistance", new String[]{"Maximum distance a train can be relocated using the wrench."});
    public final ConfigBase.ConfigFloat maxAllowedStress = this.f(0.5f, -1.0f, "maxAllowedStress", new String[]{"Maximum stress from couplings before train derails. Set to -1 to disable stress completely."});
    public final ConfigBase.ConfigBool trainAssemblyChecks = this.b(true, "trainAssemblyChecks", new String[]{"Whether to check for valid assembly when placing train tracks"});
    public final ConfigBase.ConfigFloat maxTrackBlockPlacingDistance = this.f(16.0f, 0.0f, "maxTrackBlockPlacingDistance", new String[]{"Maximum distance a track-targeting block can be placed away from a track."});
    public final ConfigBase.ConfigGroup glue = this.group(1, "glue", new String[]{"Stick anything together!"});
    public final ConfigBase.ConfigFloat maxGlueConnectionRange = this.f(24.0f, 0.0f, "maxGlueConnectionRange", new String[]{"Maximum distance between two blocks for them to be considered for glue connections."});
    public final ConfigBase.ConfigGroup extendo = this.group(1, "extendo", new String[]{"Extend even more!"});
    public final ConfigBase.ConfigFloat singleExtendoGripRange = this.extendo(3.0f, 0.0f, "singleExtendoGripRange", "How much to extend your reach when holding an Extendo-Grip. Adds to your base reach.");
    public final ConfigBase.ConfigFloat doubleExtendoGripRange = this.extendo(5.0f, 0.0f, "doubleExtendoGripRange", "How much to extend your reach when holding two Extendo-Grips. Adds to your base reach.");
    public final ConfigBase.ConfigGroup misc = this.group(1, "misc", new String[]{"Everything else"});
    public final ConfigBase.ConfigBool chainConveyorConnectionLimits = this.b(true, "chainConveyorConnectionLimits", new String[]{"Whether to check for valid connections when connecting chain conveyors."});
    public final ConfigBase.ConfigBool allowAllCopycatBlocks = this.b(false, "allowAllCopycatBlocks", new String[]{"Whether or not to allow all blocks to be inserted into Copycat blocks."});
    public final ConfigBase.ConfigBool allowContraptionMoveAll = this.b(false, "allowContraptionMoveAllow", new String[]{"Whether to allow contraptions to move any block."});
    public static final CUConfig instance = new CUConfig();

    public String getName() {
        return "server";
    }

    private ExtendoRange extendo(float f, float f2, String string, String ... stringArray) {
        return new ExtendoRange(string, f, f2, Float.MAX_VALUE, stringArray);
    }

    public static String getComment(String string) {
        return Comments.comments.getOrDefault(string, "No comment.");
    }

    public static void register() {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        instance.registerAll(builder);
        CUConfig.instance.specification = builder.build();
        Util.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)CUConfig.instance.specification);
    }

    public static void onLoad(ModConfig modConfig) {
        if (CUConfig.instance.specification == modConfig.getSpec()) {
            instance.onLoad();
        }
    }

    public static void onReload(ModConfig modConfig) {
        if (CUConfig.instance.specification == modConfig.getSpec()) {
            instance.onReload();
        }
    }

    public static <V, T extends ForgeConfigSpec.ConfigValue<V>> V getOrDefault(ConfigBase.CValue<V, T> cValue, V v) {
        try {
            return (V)cValue.get();
        }
        catch (AssertionError | IllegalStateException object) {
            if (((Throwable)object).getMessage().toLowerCase(Locale.ROOT).contains("config")) {
                return v;
            }
            throw object;
        }
    }

    public static boolean getOrFalse(ConfigBase.ConfigBool configBool) {
        return CUConfig.getOrDefault(configBool, false);
    }

    public static boolean getOrTrue(ConfigBase.ConfigBool configBool) {
        return CUConfig.getOrDefault(configBool, true);
    }

    private static class Comments {
        static final String trains = "Realism, what's that?";
        static final String placementChecks = "Whether to check for valid placement when placing train tracks";
        static final String extendedDriving = "The minimum turn that trains can drive on. Set to 0.01 if buggy.";
        static final String maxTrainRelocationDistance = "Maximum distance a train can be relocated using the wrench.";
        static final String maxAllowedStress = "Maximum stress from couplings before train derails. Set to -1 to disable stress completely.";
        static final String trainAssemblyChecks = "Whether to check for valid assembly when placing train tracks";
        static final String maxTrackBlockPlacingDistance = "Maximum distance a track-targeting block can be placed away from a track.";
        static final String glue = "Stick anything together!";
        static final String maxGlueConnectionRange = "Maximum distance between two blocks for them to be considered for glue connections.";
        static final String physicalBlockConnection = "Require blocks to be connected for glue connections.";
        static final String extendo = "Extend even more!";
        static final String singleExtendoGripRange = "How much to extend your reach when holding an Extendo-Grip. Adds to your base reach.";
        static final String doubleExtendoGripRange = "How much to extend your reach when holding two Extendo-Grips. Adds to your base reach.";
        static final String misc = "Everything else";
        static final String allowAllCopycatBlocks = "Whether or not to allow all blocks to be inserted into Copycat blocks.";
        static final String chainConveyorConnectionLimits = "Whether to check for valid connections when connecting chain conveyors.";
        static final String allowContraptionMoveAll = "Whether to allow contraptions to move any block.";
        private static final Map<String, String> comments = new HashMap<String, String>();

        private Comments() {
        }

        static {
            for (Field field : Comments.class.getDeclaredFields()) {
                try {
                    comments.put(field.getName(), (String)field.get(null));
                }
                catch (IllegalAccessException illegalAccessException) {
                    CreateUnlimited.LOGGER.error("Failed to get comment for " + field.getName(), (Throwable)illegalAccessException);
                }
            }
        }
    }

    private class ExtendoRange
    extends ConfigBase.ConfigFloat {
        public ExtendoRange(String string, float f, float f2, float f3, String ... stringArray) {
            super((ConfigBase)CUConfig.this, string, f, f2, f3, stringArray);
        }

        public void set(Double d) {
            super.set((Object)d);
        }
    }

    public static class ScreenManager {
        private static boolean done = false;

        public static BaseConfigScreen createConfigScreen(class_437 class_4372) {
            if (!done) {
                BaseConfigScreen.setDefaultActionFor((String)"createunlimited", baseConfigScreen -> baseConfigScreen.withSpecs(null, null, CUConfig.instance.specification).withButtonLabels("", "", "Settings"));
                done = true;
            }
            return new BaseConfigScreen(class_4372, "createunlimited");
        }
    }
}

