/*
 * Decompiled with CFR 0.152.
 */
package dev.rdh.createunlimited.asm;

import dev.rdh.createunlimited.Util;
import dev.rdh.createunlimited.asm.Asm;
import dev.rdh.createunlimited.boot.Transformer;
import java.util.Set;
import org.objectweb.asm.tree.ClassNode;

public final class CUMixinConfig
extends Transformer {
    @Override
    public void onLoad(String string) {
        super.onLoad(string);
        this.earlyBoot("dev.rdh.createunlimited.asm.Asm");
    }

    @Override
    protected String getPlatform() {
        try {
            Class.forName("net.minecraftforge.fml.loading.FMLLoader");
            return "1.20.1-forge";
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                Class.forName("net.neoforged.fml.loading.FMLLoader");
                return "1.21.1-neoforge";
            }
            catch (ClassNotFoundException classNotFoundException2) {
                try {
                    Class.forName("net.fabricmc.loader.api.FabricLoader");
                    String string = Util.getVersion("minecraft");
                    if (string.equals("1.20.1")) {
                        return "1.20.1-fabric";
                    }
                    throw new RuntimeException("Unsupported Minecraft version for Fabric: " + string);
                }
                catch (ClassNotFoundException classNotFoundException3) {
                    throw new RuntimeException("Could not determine platform!");
                }
            }
        }
    }

    @Override
    public Set<String> getTransformedClasses() {
        Set<String> set = super.getTransformedClasses();
        set.add("com.copycatsplus.copycats.foundation.copycat.ICopycatBlock");
        return set;
    }

    @Override
    public void transform(ClassNode classNode) {
        super.transform(classNode);
        if (classNode.name.equals("com/copycatsplus/copycats/foundation/copycat/ICopycatBlock")) {
            Asm.instrumentICopycatBlock(classNode);
        }
        if (classNode.name.equals("com/simibubi/create/content/trains/track/TrackPlacement")) {
            Asm.instrumentTrackPlacement(classNode);
        }
    }
}

