/*
 * Decompiled with CFR 0.152.
 */
package de.theidler.create_mobile_packages.items.portable_stock_ticker;

import com.simibubi.create.content.logistics.filter.FilterItem;
import com.simibubi.create.content.logistics.packager.IdentifiedInventory;
import com.simibubi.create.content.logistics.packagerLink.LogisticallyLinkedBehaviour;
import com.simibubi.create.content.logistics.packagerLink.LogisticallyLinkedBlockItem;
import com.simibubi.create.content.logistics.packagerLink.PackagerLinkBlockEntity;
import com.simibubi.create.content.logistics.stockTicker.StockTickerBlockEntity;
import de.theidler.create_mobile_packages.items.portable_stock_ticker.PortableStockTickerMenu;
import de.theidler.create_mobile_packages.items.portable_stock_ticker.StockCheckingItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.IntStream;
import net.createmod.catnip.nbt.NBTHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkHooks;
import ru.zznty.create_factory_abstractions.generic.support.GenericOrder;

public class PortableStockTicker
extends StockCheckingItem {
    public Map<UUID, List<Integer>> hiddenCategoriesByPlayer;
    protected String previouslyUsedAddress;
    protected List<ItemStack> categories = new ArrayList<ItemStack>();
    private static final String ADDRESS_TAG = "PreviousAddress";

    public PortableStockTicker(Item.Properties pProperties) {
        super(pProperties.m_41487_(1));
        this.hiddenCategoriesByPlayer = new HashMap<UUID, List<Integer>>();
    }

    public static ItemStack find(Inventory playerInventory) {
        ItemStack pst = playerInventory.f_35978_.m_21205_();
        if (playerInventory.f_35978_.m_21205_().m_41720_() instanceof PortableStockTicker) {
            return pst;
        }
        for (int i = 0; i < playerInventory.m_6643_(); ++i) {
            ItemStack portableStockTicker = playerInventory.m_8020_(i);
            if (!(playerInventory.m_8020_(i).m_41720_() instanceof PortableStockTicker)) continue;
            return portableStockTicker;
        }
        return null;
    }

    public Rarity m_41460_(ItemStack pStack) {
        return Rarity.UNCOMMON;
    }

    public boolean broadcastPackageRequest(LogisticallyLinkedBehaviour.RequestType type, GenericOrder order, IdentifiedInventory ignoredHandler, String address, Player player) {
        ItemStack itemStack;
        boolean result = super.broadcastPackageRequest(type, order, ignoredHandler, address);
        this.previouslyUsedAddress = address;
        if (player instanceof ServerPlayer && (itemStack = PortableStockTicker.find(player.m_150109_())) != null && itemStack.m_41720_() instanceof PortableStockTicker) {
            this.saveAddressToStack(itemStack, address);
        }
        return result;
    }

    @Override
    public InteractionResult m_6225_(UseOnContext pContext) {
        ItemStack stack = pContext.m_43722_();
        BlockPos pos = pContext.m_8083_();
        Level level = pContext.m_43725_();
        Player player = pContext.m_43723_();
        if (player == null) {
            return InteractionResult.FAIL;
        }
        if (!level.m_5776_() && player.m_6144_()) {
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof StockTickerBlockEntity) {
                StockTickerBlockEntity stbe = (StockTickerBlockEntity)blockEntity;
                CompoundTag tag = new CompoundTag();
                stbe.m_183515_(tag);
                this.categories = NBTHelper.readItemList((ListTag)tag.m_128437_("Categories", 10));
            } else if (level.m_7702_(pos) instanceof PackagerLinkBlockEntity) {
                this.categories = new ArrayList<ItemStack>();
            }
            this.saveCategoriesToStack(stack, this.categories);
            this.saveHiddenCategoriesByPlayerToStack(stack, this.hiddenCategoriesByPlayer);
            return super.m_6225_(pContext);
        }
        return InteractionResult.PASS;
    }

    @Override
    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        ItemStack stack = pPlayer.m_21120_(pUsedHand);
        this.previouslyUsedAddress = this.loadAddressFromStack(stack);
        this.categories = this.loadCategoriesFromStack(stack);
        this.hiddenCategoriesByPlayer = this.getHiddenCategoriesByPlayerFromStack(stack);
        if (!pLevel.f_46443_) {
            if (!LogisticallyLinkedBlockItem.isTuned((ItemStack)stack)) {
                pPlayer.m_5661_((Component)Component.m_237115_((String)"item.create_mobile_packages.portable_stock_ticker.not_linked"), true);
                return InteractionResultHolder.m_19090_((Object)pPlayer.m_21120_(pUsedHand));
            }
            SimpleMenuProvider provider = new SimpleMenuProvider((id, inv, p) -> new PortableStockTickerMenu(id, inv), (Component)Component.m_237115_((String)"item.create_mobile_packages.portable_stock_ticker"));
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)pPlayer), (MenuProvider)provider);
            if (pPlayer instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)pPlayer;
                NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)new SimpleMenuProvider((id, inv, ply) -> new PortableStockTickerMenu(id, inv), (Component)Component.m_237115_((String)"item.create_mobile_packages.portable_stock_ticker")), buf -> {});
            }
            return InteractionResultHolder.m_19090_((Object)pPlayer.m_21120_(pUsedHand));
        }
        return InteractionResultHolder.m_19090_((Object)pPlayer.m_21120_(pUsedHand));
    }

    public void saveAddressToStack(ItemStack stack, String address) {
        if (address != null && !address.isEmpty()) {
            stack.m_41784_().m_128359_(ADDRESS_TAG, address);
        }
    }

    public String loadAddressFromStack(ItemStack stack) {
        if (stack.m_41782_() && stack.m_41783_().m_128441_(ADDRESS_TAG)) {
            return stack.m_41783_().m_128461_(ADDRESS_TAG);
        }
        return null;
    }

    public void saveCategoriesToStack(ItemStack stack, List<ItemStack> categories) {
        if (categories != null) {
            stack.m_41784_().m_128365_("Categories", (Tag)NBTHelper.writeItemList(categories));
        }
    }

    public List<ItemStack> loadCategoriesFromStack(ItemStack stack) {
        if (stack.m_41782_() && stack.m_41783_().m_128441_("Categories")) {
            List readCategories = NBTHelper.readItemList((ListTag)stack.m_41783_().m_128437_("Categories", 10));
            readCategories.removeIf(itemStack -> !itemStack.m_41619_() && !(itemStack.m_41720_() instanceof FilterItem));
            return readCategories;
        }
        return new ArrayList<ItemStack>();
    }

    public void saveHiddenCategoriesByPlayerToStack(ItemStack stack, Map<UUID, List<Integer>> hiddenCategoriesByPlayer) {
        if (hiddenCategoriesByPlayer != null) {
            CompoundTag tag = new CompoundTag();
            tag.m_128365_("HiddenCategories", (Tag)NBTHelper.writeCompoundList(hiddenCategoriesByPlayer.entrySet(), e -> {
                CompoundTag c = new CompoundTag();
                c.m_128362_("Id", (UUID)e.getKey());
                c.m_128408_("Indices", (List)e.getValue());
                return c;
            }));
            stack.m_41784_().m_128365_("HiddenCategories", (Tag)tag);
        }
    }

    public Map<UUID, List<Integer>> getHiddenCategoriesByPlayerFromStack(ItemStack stack) {
        HashMap<UUID, List<Integer>> hiddenCategoriesByPlayer = new HashMap<UUID, List<Integer>>();
        if (stack.m_41782_() && stack.m_41783_().m_128441_("HiddenCategories")) {
            CompoundTag tag = stack.m_41783_().m_128469_("HiddenCategories");
            NBTHelper.iterateCompoundList((ListTag)tag.m_128437_("HiddenCategories", 10), c -> hiddenCategoriesByPlayer.put(c.m_128342_("Id"), IntStream.of(c.m_128465_("Indices")).boxed().toList()));
        }
        return hiddenCategoriesByPlayer;
    }
}

